/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystems.console.TargetArgumentCompleter;
import org.lsst.ccs.utilities.tracers.Names;

public class JLineCommandConsole
extends Subsystem {
    SynchronousCommandAgent syncAgent;
    Long defaultTimeOut = Long.getLong("timeout", 2000L);
    private ConsoleReader reader = null;
    private boolean noRedraw = Boolean.getBoolean("noRedraw");
    private TargetArgumentCompleter targetCompleter = new TargetArgumentCompleter(new String[]{"invoke", "unlock"});
    private TargetArgumentCompleter lockTargetCompleter = new TargetArgumentCompleter(new String[]{"lock", "loadCommandsForSubsystem"});
    static Logger loggerCom = Logger.getLogger("org.lsst.ccs.bus");
    static Level baseComLevel = loggerCom.getLevel();

    public JLineCommandConsole() {
        String name = Names.almostUniqueAgentName((String)"console");
        this.setName(name);
        MessagingFactory localMessagingFactory = MessagingFactory.getInstance().forSubsystem(name);
        this.syncAgent = new SynchronousCommandAgent(localMessagingFactory);
        this.setStatusBroadcastPeriod(0);
    }

    public static void main(String[] args) throws ParseException, IOException {
        Options shellOptions = new Options();
        shellOptions.addOption("h", "help", false, "Print the help message");
        shellOptions.addOption("p", "prompt", true, "Set the initial prompt");
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(shellOptions, args, true);
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(80, "CommandConsole", "", shellOptions, "", true);
        } else {
            JLineCommandConsole commandConsole = new JLineCommandConsole();
            CommandSetBuilder builder = new CommandSetBuilder();
            CompositeCommandSet compositeSet = new CompositeCommandSet();
            compositeSet.add(builder.buildCommandSet((Object)commandConsole));
            JLineShell shell = new JLineShell((CommandSet)compositeSet, line.getOptionValue("prompt"));
            shell.run();
        }
        System.exit(0);
    }
}

