/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import java.util.StringTokenizer;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.BusCommandSet;
import org.lsst.ccs.subsystem.shell.BusMasterCommands;
import org.lsst.ccs.utilities.tracers.Names;

public class ConsoleBusMaster
extends BusMaster {
    private final MessagingFactory localMessagingFactory;
    private final CompositeCommandSet ccs = new CompositeCommandSet();
    private final SynchronousCommandAgent sca;

    ConsoleBusMaster() {
        String name = Names.almostUniqueAgentName((String)"console");
        this.setName(name);
        this.localMessagingFactory = MessagingFactory.getInstance().forSubsystem(name);
        this.setStatusBroadcastPeriod(0);
        this.sca = new SynchronousCommandAgent(this.localMessagingFactory);
    }

    CompositeCommandSet getCommandSet() {
        return this.ccs;
    }

    protected void addDictionary(String name, Dictionary dictionary) {
        new StringTokenizer(name, "/");
        RoutingCommandSet crcs = new RoutingCommandSet(name, (CommandSet)new BusCommandSet(this.sca, name, dictionary));
        this.ccs.add((CommandSet)crcs);
    }

    public static void main(String[] argv) throws Exception {
        ConsoleBusMaster busMaster = new ConsoleBusMaster();
        CommandSetBuilder builder = new CommandSetBuilder();
        busMaster.ccs.add(builder.buildCommandSet((Object)new BusMasterCommands(busMaster, busMaster.sca)));
        RouteSelectionCommandSet routeSelectionCommandSet = new RouteSelectionCommandSet(busMaster.getCommandSet());
        JLineShell shell = new JLineShell((CommandSet)routeSelectionCommandSet, "${route} ccs>");
        shell.run();
        System.exit(0);
    }
}

