/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.DictionaryContext;
import org.lsst.ccs.subsystem.shell.ConsoleBusMaster;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class BusMasterCommands {
    private final SynchronousCommandAgent sca;
    private static final int timeoutMillis = 1000;
    private final ConsoleBusMaster consoleBusMaster;

    BusMasterCommands(ConsoleBusMaster consoleBusMaster, SynchronousCommandAgent sca) {
        this.consoleBusMaster = consoleBusMaster;
        this.sca = sca;
    }

    @Command(name="lock", description="Lock a subsystem")
    public void lockSubsystem(@Argument(name="subsystem", description="The name of the subsystem") String subsystem) {
        try {
            ModuleInvokerCommand cmd = new ModuleInvokerCommand("getSystemDictionary", new Object[0]);
            cmd.setDestination(subsystem);
            Object subsystemDictionary = this.sca.invoke((org.lsst.ccs.bus.Command)cmd, 1000L);
            if (subsystemDictionary instanceof Dictionary) {
                this.consoleBusMaster.addDictionary(subsystem, (Dictionary)subsystemDictionary);
            }
            cmd = new ModuleInvokerCommand("getComponentDictionariesTree", new Object[0]);
            cmd.setDestination(subsystem);
            Object componentDictionariesTree = this.sca.invoke((org.lsst.ccs.bus.Command)cmd, 1000L);
            if (componentDictionariesTree instanceof TreeBranch) {
                TreeBranch tree = (TreeBranch)componentDictionariesTree;
                for (DictionaryContext dc : tree) {
                    this.consoleBusMaster.addDictionary(String.valueOf(subsystem) + "/" + dc.getName(), dc.getDictionary());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Command(name="unlock", description="Unlock a subsystem")
    public void unlockSubsystem(@Argument(name="subsystem", description="The name of the subsystem") String subsystem) {
    }
}

