/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.plugin.jas3.trending.timeselection.PresetList;
import org.lsst.ccs.plugin.jas3.trending.timeselection.PresetsDialog;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelection;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionPanel;

public final class TimeSelectionComboBox
extends JComboBox {
    private static final String CUSTOM_BUTTON = "Choose...";
    private static final String PRESETS_BUTTON = "Presets...";
    private static final String DEFAULT_NAME = "custom";
    private static final int MAX_PRESETS = 10;
    private final PresetList timeWindowList;
    private volatile TimeSelection selection;

    public TimeSelectionComboBox(Studio application) {
        this.timeWindowList = new PresetList(application);
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setMaximumRowCount(15);
        Model model = new Model(this.timeWindowList);
        this.setModel(model);
        this.setSelectedIndex(1);
        this.selection = model.getSelectedItem();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSelection ts = TimeSelectionComboBox.this.myModel().getSelectedItem();
                switch (ts.name) {
                    case "Choose...": {
                        ts = TimeSelectionPanel.editTimeWindow(TimeSelectionComboBox.this, null);
                        if (ts == null) {
                            TimeSelectionComboBox.this.setSelectedItem(TimeSelectionComboBox.this.selection);
                            break;
                        }
                        if (ts.name.isEmpty()) {
                            ts.name = TimeSelectionComboBox.DEFAULT_NAME;
                            if (TimeSelectionComboBox.DEFAULT_NAME.equals(((TimeSelectionComboBox)TimeSelectionComboBox.this).selection.name)) {
                                TimeSelectionComboBox.this.myModel().removeElementAt(4);
                            }
                            TimeSelectionComboBox.this.myModel().insertElementAt(ts, 4);
                            TimeSelectionComboBox.this.setSelectedIndex(4);
                        } else {
                            TimeSelectionComboBox.this.timeWindowList.insert(ts);
                            Model model = new Model(TimeSelectionComboBox.this.timeWindowList);
                            model.setSelectedItem(ts);
                            TimeSelectionComboBox.this.setModel(model);
                        }
                        TimeSelectionComboBox.this.selection = ts;
                        break;
                    }
                    case "Presets...": {
                        ts = PresetsDialog.managePresets(TimeSelectionComboBox.this, TimeSelectionComboBox.this.timeWindowList);
                        if (ts == null) {
                            ts = TimeSelectionComboBox.this.selection;
                        }
                        ts.touch();
                        Model model = new Model(TimeSelectionComboBox.this.timeWindowList);
                        int index = model.getIndexOf(ts);
                        if (index == -1) {
                            index = 1;
                        }
                        TimeSelectionComboBox.this.selection = (TimeSelection)model.getElementAt(index);
                        model.setSelectedItem(TimeSelectionComboBox.this.selection);
                        TimeSelectionComboBox.this.setModel(model);
                        break;
                    }
                    default: {
                        if (!TimeSelectionComboBox.DEFAULT_NAME.equals(ts.name)) {
                            ts.touch();
                            if (TimeSelectionComboBox.DEFAULT_NAME.equals(((TimeSelectionComboBox)TimeSelectionComboBox.this).selection.name)) {
                                TimeSelectionComboBox.this.myModel().removeElementAt(4);
                            }
                        }
                        TimeSelectionComboBox.this.selection = ts;
                    }
                }
            }
        });
    }

    private Model myModel() {
        return (Model)super.getModel();
    }

    public TimeSelection getSelectedTimeWindow() {
        return this.selection;
    }

    public PresetList getPresetList() {
        return this.timeWindowList;
    }

    private class Model
    extends DefaultComboBoxModel<TimeSelection> {
        Model(PresetList tsList) {
            this.addElement(new TimeSelection(TimeSelectionComboBox.CUSTOM_BUTTON, "", "", false));
            TimeSelection selectedItem = new TimeSelection("Last Hour", "now-3600", "now", false);
            this.addElement(selectedItem);
            this.addElement(new TimeSelection("Last 6 Hours", "now-21600", "now", false));
            this.addElement(new TimeSelection("Last 24 Hours", "now-86400", "now", false));
            List<TimeSelection> customRanges = tsList.getRecent(10);
            for (TimeSelection ts : customRanges) {
                this.addElement(ts);
            }
            this.addElement(new TimeSelection(TimeSelectionComboBox.PRESETS_BUTTON, "", "", false));
            this.setSelectedItem(selectedItem);
        }

        @Override
        public TimeSelection getSelectedItem() {
            return (TimeSelection)super.getSelectedItem();
        }
    }

    private class Renderer
    implements ListCellRenderer {
        private final ListCellRenderer horse;
        private final JPanel separatorPanel = new JPanel(new BorderLayout());
        private final JSeparator separator = new JSeparator();

        Renderer(ListCellRenderer renderer) {
            this.horse = renderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.horse.getListCellRendererComponent(list, ((TimeSelection)value).name, index, isSelected, cellHasFocus);
            if (index == 0 || index == 3) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "South");
                comp = this.separatorPanel;
            } else if (index > 4 && index == TimeSelectionComboBox.this.getItemCount() - 1) {
                this.separatorPanel.removeAll();
                this.separatorPanel.add(comp, "Center");
                this.separatorPanel.add((Component)this.separator, "North");
                comp = this.separatorPanel;
            }
            return comp;
        }
    }
}

