/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionUtils;

public class TimeSelection {
    public static final String DATE_PATTERN = "MM/dd/yyyy HH:mm:ss";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private static final String DELIMITER_RE = "\\$";
    private static final String DELIMITER = "$";
    public String name;
    public String lowerEdgeString;
    public String upperEdgeString;
    private boolean persist;
    private long lastUsed;

    public TimeSelection(String name, String start, String end, boolean persistent) {
        this.name = name;
        this.lowerEdgeString = start;
        this.upperEdgeString = end;
        this.persist = persistent;
        this.lastUsed = System.currentTimeMillis();
    }

    public long getLowerEdge() {
        return this.getEdge(this.lowerEdgeString);
    }

    public long getUpperEdge() {
        return this.getEdge(this.upperEdgeString);
    }

    private long getEdge(String edgeString) {
        try {
            Date d = DATE_FORMAT.parse(edgeString);
            return d.getTime();
        }
        catch (ParseException parseException) {
            try {
                return (long)(1000.0 * TimeSelectionUtils.getSecondsForString(edgeString));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void setPersistent(boolean persistent) {
        this.persist = persistent;
    }

    public long getLastUseTime() {
        return this.lastUsed;
    }

    public void touch() {
        this.lastUsed = System.currentTimeMillis();
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + this.lowerEdgeString + " through " + this.upperEdgeString;
    }

    public String toCompressedString() {
        return String.valueOf(this.name) + DELIMITER + this.lowerEdgeString + DELIMITER + this.upperEdgeString;
    }

    public static TimeSelection parseCompressedString(String s) {
        String[] tokens = s.split(DELIMITER_RE);
        try {
            TimeSelection ts = new TimeSelection(tokens[0], tokens[1], tokens[2], true);
            ts.getLowerEdge();
            ts.getUpperEdge();
            return ts;
        }
        catch (RuntimeException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public static Comparator<TimeSelection> compareByName() {
        return new Comparator<TimeSelection>(){

            @Override
            public int compare(TimeSelection o1, TimeSelection o2) {
                return o1.name.compareTo(o2.name);
            }
        };
    }

    public static Comparator compareByTime() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)Math.signum(((TimeSelection)o2).getLastUseTime() - ((TimeSelection)o1).getLastUseTime());
            }
        };
    }
}

