/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import com.sun.jersey.api.client.WebResource;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.util.FreeHEPLookup;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.plugin.jas3.rest.LsstRestPlugin;
import org.lsst.ccs.plugin.jas3.trending.DataChannelTreeAdapter;
import org.lsst.ccs.plugin.jas3.trending.TrendingService;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionComboBox;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class LsstTrendingPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(LsstRestPlugin.class.getName());
    private Studio studio;
    private TimeSelectionComboBox selectedTimeRange;

    protected void init() throws SAXException, IOException {
        logger.finest("LsstTrendingPlugin created");
        this.studio = this.getApplication();
        final FreeHEPLookup lookup = this.studio.getLookup();
        this.addDataServerListener(lookup);
        this.selectedTimeRange = this.addTrendingToolbar();
        TrendingService trendingService = new TrendingService(){

            @Override
            public void show(String[] path) {
                FTreeProvider treeProvider = (FTreeProvider)lookup.lookup(FTreeProvider.class);
                if (treeProvider != null) {
                    FTree tree = treeProvider.tree();
                    FTreeNode node = tree.findNode(new FTreePath(path));
                    tree.adapterForClass(DataChannel.class).doubleClick(node);
                }
            }
        };
        lookup.add((Object)trendingService);
    }

    private void addDataServerListener(FreeHEPLookup lookup) {
        Lookup.Template template = new Lookup.Template(WebResource.class, "dataserver", null);
        final Lookup.Result result = lookup.lookup(template);
        this.handleWebResource(result.allInstances());
        LookupListener ll = new LookupListener(){

            public void resultChanged(LookupEvent le) {
                LsstTrendingPlugin.this.handleWebResource(result.allInstances());
            }
        };
        result.addLookupListener(ll);
    }

    private TimeSelectionComboBox addTrendingToolbar() throws SAXException, IOException {
        XMLMenuBuilder builder = this.studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("Trending.menus");
        builder.build(xml);
        JToolBar toolbar = builder.getToolBar("trending");
        TimeSelectionComboBox box = new TimeSelectionComboBox(this.studio);
        box.setEnabled(box.getItemCount() > 0);
        JLabel boxLabel = new JLabel("Trending Period: ");
        toolbar.add((Component)boxLabel, 0);
        toolbar.add((Component)box, 1);
        this.studio.addToolBar(toolbar, toolbar.getName());
        return box;
    }

    private void handleWebResource(Collection<WebResource> allInstances) {
        Iterator<WebResource> iterator = allInstances.iterator();
        if (iterator.hasNext()) {
            WebResource service = iterator.next();
            this.handleDataServer(service);
            return;
        }
        this.handleDataServer(null);
    }

    private void handleDataServer(WebResource service) {
        block4: {
            FreeHEPLookup lookup = this.studio.getLookup();
            FTreeProvider treeProvider = (FTreeProvider)lookup.lookup(FTreeProvider.class);
            if (treeProvider == null) break block4;
            FTree tree = treeProvider.tree();
            if (service == null) {
                logger.log(Level.INFO, "WebResource removed");
                FTreeNode root = tree.root();
                for (FTreeNode node : root.childNodes()) {
                    tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)this.studio, node.path()));
                }
            } else {
                logger.log(Level.INFO, "WebResource registered {0}", service);
                DataChannel.DataChannelList channelList = (DataChannel.DataChannelList)lookup.lookup(DataChannel.DataChannelList.class);
                treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new DataChannelTreeAdapter(service, this.selectedTimeRange), DataChannel.class);
                for (DataChannel chan : channelList.list) {
                    tree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)this.studio, chan.getPathAsString(), (Object)chan));
                }
            }
        }
    }
}

