/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending;

import com.sun.jersey.api.client.WebResource;
import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPoint;
import hep.aida.IPlotterStyle;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.plotter.PlotterFactory;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.plugin.jas3.trending.TimeHistory;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelection;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionComboBox;

class DataChannelTreeAdapter
extends DefaultFTreeNodeAdapter {
    private static HashMap<String, PlotPage> plotPageHash = new HashMap();
    private Studio app;
    private FTreeNodeObjectProvider objectProvider = new DataChannelObjectProvider();
    private WebResource service;
    private PlotterFactory plotterStyleFactory = new PlotterFactory();
    private Commands commands = new Commands();
    private final TimeSelectionComboBox selectedTimeRange;

    DataChannelTreeAdapter(WebResource service, TimeSelectionComboBox selectedTimeRange) {
        super(100);
        this.service = service;
        this.selectedTimeRange = selectedTimeRange;
        this.app = (Studio)Studio.getApplication();
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        this.commands.setSelectedNodes(selectedNodes);
        return this.commands;
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.commands.setSelectedNodes(nodes);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Show");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Overlay on Current Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Add to Current Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Show in New Plot");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Show on New Page");
        this.app.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        menu.addSeparator();
        return menu;
    }

    public FTreeNodeObjectProvider treeNodeObjectProvider(FTreeNode node) {
        return this.objectProvider;
    }

    public boolean doubleClick(FTreeNode node) {
        this.commands.setSelectedNodes(new FTreeNode[]{node});
        this.commands.onShow();
        return true;
    }

    public class Commands
    extends CommandProcessor {
        private FTreeNode[] selectedNodes;

        void setSelectedNodes(FTreeNode[] selectedNodes) {
            this.selectedNodes = selectedNodes;
        }

        public void onShow() {
            this.show(true, false, false, false);
        }

        public void onOverlayonCurrentPlot() {
            this.show(false, false, true, false);
        }

        public void onShowinNewPlot() {
            this.show(false, false, false, true);
        }

        public void onShowonNewPage() {
            this.show(false, true, false, false);
        }

        private void show(boolean useExistingPlot, boolean newPage, boolean overlay, boolean newPlot) {
            FTreeNode[] nodes = this.selectedNodes;
            DataChannel chan = this.dataChannel();
            if (chan != null) {
                TimeHistory timeHistory;
                PlotFactory pf = (PlotFactory)DataChannelTreeAdapter.this.app.getLookup().lookup(PlotFactory.class);
                PlotPage page = newPage ? pf.currentPage() : (useExistingPlot ? (PlotPage)plotPageHash.get(chan.getPathAsString()) : pf.currentPage());
                if (page == null) {
                    page = pf.createPage(chan.getPathAsString());
                    page.createRegions(1, 1);
                    page.showPage();
                    plotPageHash.put(chan.getPathAsString(), page);
                }
                page.showPage();
                PlotRegion region = page.currentRegion();
                if (region == null) {
                    region = page.createRegion(0.0, 0.0, 1.0, 1.0);
                } else if (newPlot) {
                    region = page.addRegion();
                }
                Plotter plotter = region.currentPlot();
                if (plotter == null) {
                    plotter = pf.createPlotterFor(IBaseHistogram.class);
                }
                if ((timeHistory = (TimeHistory)nodes[0].objectForClass(TimeHistory.class)) == null) {
                    timeHistory = new TimeHistory(chan);
                    nodes[0].addKey(TimeHistory.class, (Object)timeHistory);
                }
                TimeSelection selectedTimeSelection = DataChannelTreeAdapter.this.selectedTimeRange.getSelectedTimeWindow();
                long t1 = selectedTimeSelection.getLowerEdge();
                long t2 = selectedTimeSelection.getUpperEdge();
                Data data = this.getDataChannelData(chan.getId(), t1, t2);
                timeHistory.setDataArray(data.getTrendingResult().getTrendingDataArray());
                String nameAndTitle = chan.getPathAsString();
                DataPointSet pst = new DataPointSet(nameAndTitle, nameAndTitle, 2);
                int i = 0;
                while (i < timeHistory.size()) {
                    TrendingData d = timeHistory.getData(i);
                    IDataPoint p = pst.addPoint();
                    p.coordinate(0).setValue((double)d.getAxisvalue().getValue() / 1000.0);
                    p.coordinate(1).setValue(d.getValue("value"));
                    ++i;
                }
                IPlotterStyle style = DataChannelTreeAdapter.this.plotterStyleFactory.createPlotterStyle();
                IAxisStyle xAxisStyle = style.xAxisStyle();
                xAxisStyle.setParameter("type", "date");
                xAxisStyle.setParameter("lowerLimit", String.valueOf(t1 / 1000L));
                xAxisStyle.setParameter("upperLimit", String.valueOf(t2 / 1000L));
                plotter.plot((Object)pst, overlay ? 1 : 0, (Object)style, "");
                region.showPlot(plotter);
            }
        }

        private DataChannel dataChannel() {
            FTreeNode[] nodes = this.selectedNodes;
            return (DataChannel)nodes[0].objectForClass(DataChannel.class);
        }

        Data getDataChannelData(long id, long t1, long t2) {
            WebResource resource = DataChannelTreeAdapter.this.service.path("data").path(String.valueOf(id));
            resource = resource.queryParam("t1", String.valueOf(t1)).queryParam("t2", String.valueOf(t2)).queryParam("flavor", "raw");
            return (Data)resource.accept(new String[]{"text/xml"}).get(Data.class);
        }
    }

    class DataChannelObjectProvider
    implements FTreeNodeObjectProvider {
        DataChannelObjectProvider() {
        }

        public Object objectForNode(FTreeNode node, Class clazz) {
            Object obj = node.value(TimeHistory.class);
            return obj;
        }
    }
}

