package org.lsst.ccs.plugin.jas3.trending;

import com.sun.jersey.api.client.WebResource;
import hep.aida.IAxisStyle;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPoint;
import hep.aida.IPlotterStyle;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.plotter.PlotterFactory;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.ws.rs.core.MediaType;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelection;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionComboBox;

/**
 * Defines behavior for tree nodes corresponding to trending channels.
 * @author turri
 */
class DataChannelTreeAdapter extends DefaultFTreeNodeAdapter {

    private static HashMap<String, PlotPage> plotPageHash = new HashMap<String, PlotPage>();
    private Studio app;
    private FTreeNodeObjectProvider objectProvider = new DataChannelObjectProvider();
    private WebResource service;
    private PlotterFactory plotterStyleFactory = new PlotterFactory();
    private Commands commands = new Commands();
    private final TimeSelectionComboBox selectedTimeRange;

    DataChannelTreeAdapter(WebResource service, TimeSelectionComboBox selectedTimeRange) {
        super(100);
        this.service = service;
        this.selectedTimeRange = selectedTimeRange;
        app = (Studio) Studio.getApplication();
    }

    @Override
    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        commands.setSelectedNodes(selectedNodes);
        return commands;
    }

    @Override
    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        commands.setSelectedNodes(nodes);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Show");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Overlay on Current Plot");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Add to Current Plot");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Show in New Plot");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        item = new JMenuItem("Show on New Page");
        app.getCommandTargetManager().add(new CommandSourceAdapter(item));
        menu.add(item);
        menu.addSeparator();
        return menu;
    }

    @Override
    public FTreeNodeObjectProvider treeNodeObjectProvider(FTreeNode node) {
        return objectProvider;
    }

    @Override
    public boolean doubleClick(FTreeNode node) {
        commands.setSelectedNodes(new FTreeNode[]{node});
        commands.onShow();
        return true;
    }

    class DataChannelObjectProvider implements FTreeNodeObjectProvider {

        @Override
        public Object objectForNode(FTreeNode node, Class clazz) {
            Object obj = node.value(TimeHistory.class);
            return obj;
        }
    }

    public class Commands extends CommandProcessor {

        private FTreeNode[] selectedNodes;

        void setSelectedNodes(FTreeNode[] selectedNodes) {
            this.selectedNodes = selectedNodes;
        }

        public void onShow() {
            show(true, false, false, false);
        }

        public void onOverlayonCurrentPlot() {
            show(false, false, true, false);
        }

        public void onShowinNewPlot() {
            show(false, false, false, true);
        }

        public void onShowonNewPage() {
            show(false, true, false, false);
        }

        private void show(boolean useExistingPlot, boolean newPage, boolean overlay, boolean newPlot) {

            FTreeNode[] nodes = selectedNodes;
            DataChannel chan = dataChannel();

            if (chan != null) {
                PlotRegion region;
                PlotPage page;

                PlotFactory pf = (PlotFactory) app.getLookup().lookup(PlotFactory.class);
                if (newPage) {
                    page = pf.currentPage();
                } else if (useExistingPlot) {
                    page = plotPageHash.get(chan.getPathAsString());
                } else {
                    page = pf.currentPage();
                }

                if (page == null) {
                    page = pf.createPage(chan.getPathAsString());
                    page.createRegions(1, 1);
                    page.showPage();
                    plotPageHash.put(chan.getPathAsString(), page);
                }
                page.showPage();

                region = page.currentRegion();
                if (region == null) {
                    region = page.createRegion(0, 0, 1, 1);
                } else if (newPlot) {
                    region = page.addRegion();
                }
                Plotter plotter = region.currentPlot();

                if (plotter == null) {
                    plotter = pf.createPlotterFor(IBaseHistogram.class);
                }

                TimeHistory timeHistory = (TimeHistory) nodes[0].objectForClass(TimeHistory.class);
                if (timeHistory == null) {
                    timeHistory = new TimeHistory(chan);
                    nodes[0].addKey(TimeHistory.class, timeHistory);
                }
                TimeSelection selectedTimeSelection = selectedTimeRange.getSelectedTimeWindow();
                long t1 = selectedTimeSelection.getLowerEdge();
                long t2 = selectedTimeSelection.getUpperEdge();

                Data data = getDataChannelData(chan.getId(), t1, t2);
                timeHistory.setDataArray(data.getTrendingResult().getTrendingDataArray());

                String nameAndTitle = chan.getPathAsString();
                DataPointSet pst = new DataPointSet(nameAndTitle, nameAndTitle, 2);

                for (int i = 0; i < timeHistory.size(); i++) {
                    TrendingData d = timeHistory.getData(i);

                    IDataPoint p = pst.addPoint();
                    p.coordinate(0).setValue(d.getAxisvalue().getValue() / 1000.);
                    p.coordinate(1).setValue(d.getValue("value"));
                }

                IPlotterStyle style = plotterStyleFactory.createPlotterStyle();
                final IAxisStyle xAxisStyle = style.xAxisStyle();
                xAxisStyle.setParameter("type", "date");
                xAxisStyle.setParameter("lowerLimit", String.valueOf(t1 / 1000));
                xAxisStyle.setParameter("upperLimit", String.valueOf(t2 / 1000));

                plotter.plot(pst, overlay ? Plotter.OVERLAY : Plotter.NORMAL, style, "");
                region.showPlot(plotter);
            }
        }

        private DataChannel dataChannel() {
            FTreeNode[] nodes = selectedNodes;
            return (DataChannel) nodes[0].objectForClass(DataChannel.class);
        }
        /**
         * Fetch the data for a particular channel. Note this is currently being
         * called synchronously on the event dispatch thread which is not ideal.
         * @param id Id of channel to fetch
         * @param t1 Lower limit of time range to fetch
         * @param t2 Upper limit of time range to fetch
         * @return The data for this channel/time range
         */
        Data getDataChannelData(long id, long t1, long t2) {

            WebResource resource = service.path("data").path(String.valueOf(id));
            resource = resource.queryParam("t1", String.valueOf(t1)).queryParam("t2", String.valueOf(t2)).queryParam("flavor", "raw");

            return resource.accept(MediaType.TEXT_XML).get(Data.class);
        }
    }
}
