/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.font.FontUtilities;
import org.freehep.graphicsio.font.FontTable;
import org.freehep.graphicsio.svg.SVGGlyph;
import org.freehep.graphicsio.svg.SVGGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGFontTable {
    private Hashtable<Font, Hashtable<String, SVGGlyph>> glyphs = new Hashtable();
    private static final Properties replaceFonts = new Properties();

    private SVGGlyph addGlyph(int c, Font font) {
        Hashtable<String, SVGGlyph> glyphs = this.getGlyphs(font);
        SVGGlyph result = glyphs.get(String.valueOf(c));
        if (result == null) {
            result = this.createGlyph(c, font);
            glyphs.put(String.valueOf(c), result);
        }
        return result;
    }

    private SVGGlyph createGlyph(int c, Font font) {
        GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(null, true, true), String.valueOf((char)c));
        return new SVGGlyph(glyphVector.getGlyphOutline(0), c, glyphVector.getGlyphMetrics(0));
    }

    protected void addGlyphs(String string, Font font) {
        font = this.untransform(font);
        for (int i = 0; i < string.length(); ++i) {
            this.addGlyph(string.charAt(i), font);
        }
    }

    private Hashtable<String, SVGGlyph> getGlyphs(Font font) {
        Hashtable<String, SVGGlyph> result = this.glyphs.get(font = this.untransform(font));
        if (result == null) {
            result = new Hashtable();
            this.glyphs.put(font, result);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Enumeration<Font> fonts = this.glyphs.keys();
        while (fonts.hasMoreElements()) {
            Font font = fonts.nextElement();
            Hashtable attributes = FontUtilities.getAttributes((Font)font);
            SVGFontTable.normalize(attributes);
            result.append("<font id=\"");
            result.append(attributes.get(TextAttribute.FAMILY));
            result.append("\">\n");
            result.append("<font-face font-family=\"");
            result.append(attributes.get(TextAttribute.FAMILY));
            result.append("\" ");
            if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
                result.append("font-weight=\"bold\" ");
            } else {
                result.append("font-weight=\"normal\" ");
            }
            if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
                result.append("font-style=\"italic\" ");
            } else {
                result.append("font-style=\"normal\" ");
            }
            Float size = (Float)attributes.get(TextAttribute.SIZE);
            result.append("font-size=\"");
            result.append(SVGGraphics2D.fixedPrecision(size.floatValue()));
            result.append("\" ");
            result.append("units-per-em=\"");
            result.append(SVGGraphics2D.fixedPrecision(SVGGlyph.FONT_SIZE));
            result.append("\" ");
            TextLayout tl = new TextLayout("By", font, new FontRenderContext(new AffineTransform(), true, true));
            result.append("ascent=\"");
            result.append(tl.getAscent());
            result.append("\" ");
            result.append("desscent=\"");
            result.append(tl.getDescent());
            result.append("\" ");
            result.append("/>\n");
            SVGGlyph glyph = this.createGlyph(font.getMissingGlyphCode(), font);
            result.append("<missing-glyph ");
            result.append(glyph.getHorizontalAdvanceXString());
            result.append(" ");
            result.append(glyph.getPathString());
            result.append("/>\n");
            Iterator<SVGGlyph> glyphs = this.getGlyphs(font).values().iterator();
            while (glyphs.hasNext()) {
                result.append(glyphs.next().toString());
                result.append("\n");
            }
            result.append("</font>\n");
        }
        return result.toString();
    }

    private Font untransform(Font font) {
        Hashtable attributes = FontUtilities.getAttributes((Font)font);
        attributes.put(TextAttribute.SIZE, new Float(SVGGlyph.FONT_SIZE));
        attributes.remove(TextAttribute.TRANSFORM);
        attributes.remove(TextAttribute.SUPERSCRIPT);
        return new Font(attributes);
    }

    public static void normalize(Map<AttributedCharacterIterator.Attribute, Object> attributes) {
        FontTable.normalize(attributes);
        String family = replaceFonts.getProperty(((String)attributes.get(TextAttribute.FAMILY)).toLowerCase());
        if (family == null) {
            family = (String)attributes.get(TextAttribute.FAMILY);
        }
        attributes.put(TextAttribute.FAMILY, family);
    }

    static {
        replaceFonts.setProperty("dialog", "Helvetica");
        replaceFonts.setProperty("dialoginput", "Courier New");
        replaceFonts.setProperty("serif", "Times");
        replaceFonts.setProperty("timesroman", "Times");
        replaceFonts.setProperty("sansserif", "Helvetica");
        replaceFonts.setProperty("monospaced", "Courier New");
        replaceFonts.setProperty("zapfdingbats", "Wingdings");
    }
}

