/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.xml.parsers.SAXParserFactory;
import org.freehep.application.AboutDialog;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.ApplicationListener;
import org.freehep.application.HelpService;
import org.freehep.application.PrintPreview;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.SplashScreen;
import org.freehep.application.StatusBar;
import org.freehep.application.services.ServiceManager;
import org.freehep.swing.ErrorDialog;
import org.freehep.swing.RecentFileList;
import org.freehep.swing.popup.GlobalMouseListener;
import org.freehep.swing.popup.GlobalPopupListener;
import org.freehep.swing.popup.PopupListener;
import org.freehep.util.VersionComparator;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.CommandTargetManager;
import org.freehep.util.commandline.CommandLine;
import org.freehep.util.commandline.CommandLineException;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Application
extends JPanel {
    private static Application theApp;
    private String appName;
    private ServiceManager serviceManager;
    private Properties appProperties;
    private Properties userProperties;
    private XMLMenuBuilder xmlMenuBuilder;
    private CommandProcessor commandProcessor;
    private CommandTargetManager commandTargetManager;
    private CommandLine commandLine;
    private HelpService helpService;
    private StatusBar statusBar;
    private JMenuBar menuBar;
    private JPanel toolBarHolder;
    private JPanel menuPane;
    private Map<String, RecentFileList> rflHash;
    private boolean statusBarVisible = false;
    private boolean toolBarVisible = false;
    private InitializationListener l = new DefaultInitializationListener();
    private List queueRunnable;
    private final Object queueLock = new Object();

    protected Application(String appName) {
        super(new BorderLayout());
        if (theApp != null) {
            throw new RuntimeException("Attempt to create multiple instances of Application");
        }
        this.appName = appName;
        theApp = this;
        try {
            String actual = System.getProperty("java.version");
            String required = this.getAppProperties().getProperty("minimumJavaVersion");
            if (Application.versionNumberCompare(actual, required) < 0) {
                throw new RuntimeException("Wrong Java version, required: " + required + " actual: " + actual);
            }
        }
        catch (SecurityException x) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ServiceManager createServiceManager() throws InitializationException {
        String className = System.getProperty("jnlp.org.freehep.application.ServiceManager");
        if (className == null) {
            className = System.getProperty("org.freehep.application.ServiceManager");
        }
        if (className == null) {
            className = "org.freehep.application.services.app.AppServiceManager";
        }
        return (ServiceManager)Application.createObjectFromProperty(className, ServiceManager.class);
    }

    public ServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            this.serviceManager = this.createServiceManager();
        }
        return this.serviceManager;
    }

    public static Application getApplication() {
        return theApp;
    }

    public RecentFileList getRecentFileList(String name) {
        RecentFileList rfl;
        if (this.rflHash == null) {
            this.rflHash = new HashMap<String, RecentFileList>();
        }
        if ((rfl = this.rflHash.get(name)) == null) {
            rfl = new RecentFileList(name);
            rfl.load(this.getUserProperties());
            this.rflHash.put(name, rfl);
        }
        return rfl;
    }

    protected void saveUserProperties() {
        JFrame f;
        Properties up = this.getUserProperties();
        if (this.rflHash != null) {
            for (RecentFileList rfl : this.rflHash.values()) {
                rfl.save(up);
            }
        }
        if ((f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this)) != null && f.getState() == 0) {
            PropertyUtilities.setRectangle(up, "window", f.getBounds());
        }
        this.storeUserProperties(this.getUserProperties());
    }

    private void loadUserProperties(Properties user) {
        this.getServiceManager().loadUserPreferences(user);
    }

    private void storeUserProperties(Properties user) {
        this.getServiceManager().storeUserPreferences(user);
    }

    public void setLookAndFeel(String lookAndFeelName) {
        try {
            if (!UIManager.getLookAndFeel().getClass().getName().equals(lookAndFeelName)) {
                UIManager.setLookAndFeel(lookAndFeelName);
                Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
                if (f != null) {
                    Application.updateComponentTreeUI(f);
                }
            }
            this.getUserProperties().setProperty("lookAndFeel", lookAndFeelName);
        }
        catch (Exception x) {
            this.error("Could not set look and feel " + lookAndFeelName, x);
        }
    }

    public String getVersion() {
        return this.getAppProperties().getProperty("version");
    }

    public String getFullVersion() {
        Properties prop = this.getAppProperties();
        return prop.getProperty("fullVersion");
    }

    public static int versionNumberCompare(String v1, String v2) throws NumberFormatException {
        VersionComparator comp = new VersionComparator();
        return comp.versionNumberCompare(v1, v2);
    }

    public PrintPreview createPrintPreview() {
        return new AppPrintPreview();
    }

    public void showDialog(JDialog dlg, String key) {
        Rectangle bounds = PropertyUtilities.getRectangle(this.getUserProperties(), key, null);
        if (bounds == null) {
            dlg.pack();
            dlg.setLocationRelativeTo(this);
        } else {
            dlg.setBounds(bounds);
        }
        dlg.setVisible(true);
        PropertyUtilities.setRectangle(this.getUserProperties(), key, dlg.getBounds());
    }

    public CommandProcessor getCommandProcessor() {
        if (this.commandProcessor == null) {
            this.commandProcessor = this.createCommandProcessor();
        }
        return this.commandProcessor;
    }

    protected CommandProcessor createCommandProcessor() {
        return new ApplicationCommandProcessor();
    }

    public CommandTargetManager getCommandTargetManager() {
        if (this.commandTargetManager == null) {
            this.commandTargetManager = this.createCommandTargetManager();
        }
        return this.commandTargetManager;
    }

    protected CommandLine createCommandLine() {
        Properties props = this.getAppProperties();
        int n = PropertyUtilities.getInteger(props, "numberOfParameters");
        boolean multiLevel = n < 0;
        return new CommandLine(this.getAppName(), this.getFullVersion(), Math.max(n, 0), multiLevel);
    }

    public CommandLine getCommandLine() {
        if (this.commandLine == null) {
            this.commandLine = this.createCommandLine();
            this.commandLine.addOption("noSplash", null, "Suppress splash screen on startup");
            this.commandLine.addOption("clearUserProperties", null, "Clears the user properties");
            this.commandLine.addBailOutOption("help", "h", "Display this message");
            this.commandLine.addMultiOption("D", "key=value", "Set application property");
            this.commandLine.addMultiOption("d", "key=value", "Set user property, persists between sessions");
        }
        return this.commandLine;
    }

    protected CommandTargetManager createCommandTargetManager() {
        return new ApplicationCommandTargetManager();
    }

    public final void showHelpTopic(String helpTopicTarget) {
        this.showHelpTopic(helpTopicTarget, "TOC");
    }

    public void showHelpTopic(String helpTopicTarget, Component owner) {
        this.showHelpTopic(helpTopicTarget, "TOC", owner);
    }

    private void showHelpTopic(String helpTopicTarget, String navigatorView) {
        this.showHelpTopic(helpTopicTarget, navigatorView, this);
    }

    private void showHelpTopic(final String helpTopicTarget, final String navigatorView, final Component owner) {
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                try {
                    HelpService hs = Application.this.getHelpService();
                    hs.showHelpTopic(helpTopicTarget, navigatorView, owner);
                }
                catch (IllegalArgumentException x) {
                    Application.this.error("Help topic not found", x);
                }
            }
        };
        this.whenAvailable("help", r2);
    }

    public void whenAvailable(final String part, final Runnable run) {
        try {
            if (!this.getServiceManager().isAvailable(part)) {
                Runnable r1 = new Runnable(){

                    @Override
                    public void run() {
                        if (Application.this.getServiceManager().makeAvailable(part)) {
                            SwingUtilities.invokeLater(run);
                        }
                    }
                };
                Thread download = new Thread(r1);
                download.start();
            } else {
                run.run();
            }
        }
        catch (InitializationException x) {
            this.error("Could not download " + part, x);
        }
    }

    private HelpService getHelpService() throws InitializationException {
        if (this.helpService == null) {
            this.helpService = this.createHelpService();
        }
        return this.helpService;
    }

    protected HelpService createHelpService() throws InitializationException {
        try {
            return (HelpService)Class.forName("org.freehep.application.HelpServiceImpl").newInstance();
        }
        catch (ExceptionInInitializerError x) {
            Throwable t = x.getException();
            throw new InitializationException("Could not create help service", t == null ? x : t);
        }
        catch (Throwable x) {
            throw new InitializationException("Could not create help service", x);
        }
    }

    public final void showHelpContents() {
        this.showHelpTopic(null);
    }

    public final void showHelpIndex() {
        this.showHelpTopic(null, "Index");
    }

    public final void showHelpSearch() {
        this.showHelpTopic(null, "Search");
    }

    public void about() {
        JDialog dlg = this.createAboutDialog();
        dlg.pack();
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
    }

    public void error(String message) {
        this.error(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(final String message, final Throwable detail) {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.queueRunnable != null) {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        Application.this.error(message, detail);
                    }
                };
                this.queueRunnable.add(run);
            } else {
                Application.error(this, message, detail);
            }
        }
    }

    public static void error(Component source, String message) {
        Application.error(source, message, null);
    }

    public static void error(final Component source, final String message, final Throwable detail) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Application.error(source, message, detail);
                }
            };
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException x) {
            }
            catch (InvocationTargetException x) {}
        } else {
            ErrorDialog.showErrorDialog((Component)source, (Object)message, (Throwable)detail);
        }
    }

    public int error(String message, Throwable detail, Object[] options) {
        return Application.error(this, message, detail, options);
    }

    public static int error(final Component source, final String message, final Throwable detail, final Object[] options) {
        if (SwingUtilities.isEventDispatchThread()) {
            return ErrorDialog.showErrorDialog((Component)source, (Object)message, (Throwable)detail, (Object[])options);
        }
        Callable<Integer> run = new Callable<Integer>(){

            @Override
            public Integer call() {
                return Application.error(source, message, detail, options);
            }
        };
        FutureTask<Integer> task = new FutureTask<Integer>(run);
        try {
            SwingUtilities.invokeAndWait(task);
            return task.get();
        }
        catch (InterruptedException x) {
        }
        catch (InvocationTargetException x) {
        }
        catch (ExecutionException x) {
            // empty catch block
        }
        return -1;
    }

    protected JDialog createAboutDialog() {
        return new AboutDialog(this);
    }

    protected JPanel createToolBarHolder() {
        return new JPanel(new BorderLayout());
    }

    public JPanel getToolBarHolder() {
        if (this.toolBarHolder == null) {
            this.toolBarHolder = this.createToolBarHolder();
            if (this.toolBarVisible) {
                this.toolBarHolder.add(this);
                this.menuPane.add(this.toolBarHolder);
            }
        }
        return this.toolBarHolder;
    }

    protected StatusBar createStatusBar() {
        return new StatusBar();
    }

    public StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = this.createStatusBar();
        }
        return this.statusBar;
    }

    public void setStatusMessage(String message) {
        if (this.l != null) {
            this.l.setStage(message);
        } else {
            this.getStatusBar().setMessage(message);
        }
    }

    public boolean getShowStatusBar() {
        return this.statusBarVisible;
    }

    public void setShowStatusBar(boolean show) {
        if (show != this.statusBarVisible) {
            StatusBar sb = this.getStatusBar();
            if (show) {
                this.menuPane.add((Component)sb, "South");
            } else {
                this.menuPane.remove(sb);
            }
            this.statusBarVisible = show;
            this.menuPane.revalidate();
            PropertyUtilities.setBoolean(this.getUserProperties(), "showStatusBar", show);
        }
    }

    public boolean getShowToolBar() {
        return this.toolBarVisible;
    }

    public void setShowToolBar(boolean show) {
        if (show != this.toolBarVisible) {
            if (this.toolBarHolder != null) {
                if (show) {
                    this.toolBarHolder.add(this);
                    this.menuPane.add(this.toolBarHolder);
                } else {
                    this.menuPane.remove(this.toolBarHolder);
                    this.menuPane.add(this);
                }
            }
            this.menuPane.revalidate();
            this.menuPane.repaint();
            this.toolBarVisible = show;
            PropertyUtilities.setBoolean(this.getUserProperties(), "showToolBar", show);
        }
    }

    public void exit() {
        String confirm = this.getUserProperties().getProperty("confirmQuit");
        if (!confirm.equals("never")) {
            String confirmQuitMessage = this.getUserProperties().getProperty("confirmQuitMessage");
            String confirmQuitTitle = this.getUserProperties().getProperty("confirmQuitTitle");
            Box message = Box.createVerticalBox();
            message.add(new JLabel(confirmQuitMessage));
            JCheckBox ask = new JCheckBox("Don't ask me this again");
            if (!confirm.equals("always")) {
                message.add(ask);
            }
            if (JOptionPane.showConfirmDialog(this, message, confirmQuitTitle, 0) != 0) {
                return;
            }
            if (ask.isSelected()) {
                this.getUserProperties().setProperty("confirmQuit", "never");
            }
        }
        this.fireAboutToExit(new ApplicationEvent(this, ApplicationEvent.APPLICATION_EXITING));
        this.saveUserProperties();
        System.exit(0);
    }

    private void addToken(String token, List<String> command) {
        if (token.contains(" ")) {
            token = "\"" + token + "\"";
        }
        command.add(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.fireAboutToExit(new ApplicationEvent(this, ApplicationEvent.APPLICATION_EXITING));
        this.saveUserProperties();
        final ArrayList<String> cmd = new ArrayList<String>();
        String jnlp = System.getProperty("jnlpx.origFilenameArg");
        try {
            if (jnlp == null) {
                String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                this.addToken(java, cmd);
                for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                    if (arg.contains("-agentlib") || arg.contains("Xdebug") || arg.contains("Xrunjdwp")) continue;
                    this.addToken(arg, cmd);
                }
                String[] mainCommand = System.getProperty("sun.java.command").split(" ");
                if (mainCommand[0].endsWith(".jar")) {
                    this.addToken("-jar", cmd);
                    this.addToken(new File(mainCommand[0]).getPath(), cmd);
                } else {
                    this.addToken("-cp", cmd);
                    this.addToken(System.getProperty("java.class.path"), cmd);
                }
                for (int i = 1; i < mainCommand.length; ++i) {
                    this.addToken(mainCommand[i], cmd);
                }
            } else {
                String javaws = System.getProperty("jnlpx.home", System.getProperty("java.home") + File.separator + "bin") + File.separator + "javaws";
                this.addToken(javaws, cmd);
                this.addToken(jnlp, cmd);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        ProcessBuilder pb = new ProcessBuilder(cmd);
                        Map<String, String> env = pb.environment();
                        for (String var : new String[]{"JASJVM_ARGS", "JAVAWS_VM_ARGS"}) {
                            String value = env.get(var);
                            if (value == null || value.isEmpty()) continue;
                            String[] tokens = value.split(" ");
                            StringBuilder sb = new StringBuilder();
                            for (String token : tokens) {
                                if (token.contains("Xdebug") || token.contains("Xrunjdwp")) continue;
                                sb.append(token).append(" ");
                            }
                            if (sb.length() > 0) {
                                env.put(var, sb.substring(0, sb.length() - 1));
                                continue;
                            }
                            env.remove(var);
                        }
                        pb.start();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception x) {
            JOptionPane.showMessageDialog(null, x);
        }
        finally {
            System.exit(0);
        }
    }

    protected InitializationListener createSplashScreen() {
        boolean noSplash;
        final Properties prop = this.getUserProperties();
        boolean bl = noSplash = this.getCommandLine().getOption("noSplash") != null;
        if (!noSplash && PropertyUtilities.getBoolean(prop, "showSplash", true)) {
            String splashTitle = prop.getProperty("splashTitle");
            URL url = PropertyUtilities.getURL(prop, "splashImage", null);
            if (url == null) {
                throw new InitializationException("Could not find splash image");
            }
            final SplashScreen splash = new SplashScreen(new ImageIcon(url), "Starting...", splashTitle);
            final int nSteps = PropertyUtilities.getInteger(prop, "numberOfInitializationStages", 10);
            splash.setVisible(true);
            return new InitializationListener(){
                private int n = 0;

                @Override
                public void setStage(String message) {
                    splash.showStatus(message, 100 * this.n++ / nSteps);
                }

                @Override
                public void failed(Throwable t) {
                    splash.close();
                }

                @Override
                public void succeeded() {
                    splash.close();
                    PropertyUtilities.setInteger(prop, "numberOfInitializationStages", this.n);
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFrame createFrame(String[] argv) throws InitializationException {
        try {
            String key;
            this.queueRunnable = new ArrayList();
            CommandLine cl = this.getCommandLine();
            boolean rc = cl.parse(argv);
            if (!rc) {
                System.out.println(cl.getHelp());
                System.exit(0);
            }
            if (cl.hasOption("clearUserProperties")) {
                this.getUserProperties().clear();
            }
            Vector v = cl.getMultiOption("D");
            Properties prop = this.getAppProperties();
            for (String opt : v) {
                StringTokenizer s = new StringTokenizer(opt, "=");
                int n = s.countTokens();
                if (n == 1) {
                    prop.setProperty(s.nextToken(), "true");
                    continue;
                }
                if (n == 2) {
                    prop.setProperty(s.nextToken(), s.nextToken());
                    continue;
                }
                throw new InitializationException("Illegal value \"" + opt + "\" for option");
            }
            Properties properties = System.getProperties();
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                key = i.next().toString();
                if (!key.startsWith("freehep.app.")) continue;
                String value = properties.getProperty(key);
                this.getAppProperties().setProperty(key.substring(12), value);
                i.remove();
            }
            v = cl.getMultiOption("d");
            prop = this.getUserProperties();
            for (String opt : v) {
                StringTokenizer s = new StringTokenizer(opt, "=");
                int n = s.countTokens();
                if (n == 1) {
                    prop.setProperty(s.nextToken(), "true");
                    continue;
                }
                if (n == 2) {
                    prop.setProperty(s.nextToken(), s.nextToken());
                    continue;
                }
                throw new InitializationException("Illegal value \"" + opt + "\" for option");
            }
            i = properties.keySet().iterator();
            while (i.hasNext()) {
                key = i.next().toString();
                if (!key.startsWith("freehep.user.")) continue;
                String value = properties.getProperty(key);
                this.getUserProperties().setProperty(key.substring(13), value);
                i.remove();
            }
        }
        catch (CommandLineException x) {
            throw new InitializationException("Illegal Command Line Argument", x);
        }
        InitializationListener splash = this.createSplashScreen();
        if (splash != null) {
            this.l = splash;
        }
        try {
            List errors;
            String topLevelPopupMenu;
            String topLevelMenu;
            this.setStatusMessage("Creating command manager");
            CommandTargetManager ctm = this.getCommandTargetManager();
            ctm.add((CommandGroup)this.getCommandProcessor());
            this.setStatusMessage("Creating main frame");
            Properties appProp = this.getUserProperties();
            URL iconURL = PropertyUtilities.getURL(appProp, "icon", null);
            Image iconImage = iconURL == null ? null : new ImageIcon(iconURL).getImage();
            this.menuPane = new JPanel(new BorderLayout());
            this.menuPane.add(this);
            String toolbar = appProp.getProperty("topLevelToolBar");
            if (toolbar != null) {
                JToolBar tb = this.getXMLMenuBuilder().getToolBar(toolbar);
                if (tb == null) {
                    throw new InitializationException("Could not find toolbar " + toolbar);
                }
                this.getToolBarHolder().add((Component)tb, "North");
            }
            if ((topLevelMenu = appProp.getProperty("topLevelMenuBar")) != null) {
                this.menuBar = this.getXMLMenuBuilder().getMenuBar(topLevelMenu);
                if (this.menuBar == null) {
                    throw new InitializationException("Could not find menuBar " + topLevelMenu);
                }
            }
            if ((topLevelPopupMenu = appProp.getProperty("topLevelPopupMenu")) != null) {
                JPopupMenu popup = this.getXMLMenuBuilder().getPopupMenu(topLevelPopupMenu);
                if (popup == null) {
                    throw new InitializationException("Could not find popup menu " + topLevelPopupMenu);
                }
                this.addMouseListener((MouseListener)new PopupListener(popup));
            }
            boolean showToolBar = PropertyUtilities.getBoolean(appProp, "showToolBar", true);
            this.setShowToolBar(showToolBar);
            boolean showStatus = PropertyUtilities.getBoolean(appProp, "showStatusBar", true);
            this.setShowStatusBar(showStatus);
            this.init();
            this.fireInitializationComplete(new ApplicationEvent(this, ApplicationEvent.INITIALIZATION_COMPLETE));
            this.setStatusMessage("Setting Look and Feel...");
            String laf = this.getUserProperties().getProperty("lookAndFeel", "System");
            if (laf.equalsIgnoreCase("System")) {
                laf = UIManager.getSystemLookAndFeelClassName();
            } else if (laf.equalsIgnoreCase("Java")) {
                laf = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            if (!UIManager.getLookAndFeel().getClass().getName().equals(laf)) {
                try {
                    UIManager.setLookAndFeel(laf);
                    Application.updateComponentTreeUI(this.menuPane);
                    if (this.menuBar != null) {
                        Application.updateComponentTreeUI(this.menuBar);
                    }
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            this.setStatusMessage("Starting command manager");
            ctm.start();
            Rectangle bounds = this.getPreferredBounds();
            JFrame frame = new JFrame(appProp.getProperty("title"));
            frame.setIconImage(iconImage);
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Application.this.exit();
                }
            });
            GlobalMouseListener gml = new GlobalMouseListener((Component)frame);
            gml.addMouseListener((MouseListener)new GlobalPopupListener());
            frame.setContentPane(this.menuPane);
            if (this.menuBar != null) {
                frame.setJMenuBar(this.menuBar);
            }
            if (bounds == null) {
                frame.pack();
            } else {
                frame.setBounds(bounds);
            }
            Object object = this.queueLock;
            synchronized (object) {
                errors = this.queueRunnable;
                this.queueRunnable = null;
            }
            for (Runnable r : errors) {
                SwingUtilities.invokeLater(r);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Application.this.fireApplicationVisible(new ApplicationEvent(Application.this, ApplicationEvent.APPLICATION_VISIBLE));
                }
            };
            SwingUtilities.invokeLater(r);
            this.l.succeeded();
            this.l = null;
            return frame;
        }
        catch (InitializationException x) {
            this.l.failed(x);
            throw x;
        }
    }

    protected void init() {
    }

    protected Rectangle getPreferredBounds() {
        return PropertyUtilities.getRectangle(this.getUserProperties(), "window", null);
    }

    public Properties getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = this.createUserProperties();
            this.loadUserProperties(this.userProperties);
        }
        return this.userProperties;
    }

    protected Properties createUserProperties() {
        return new PropertyUtilities.TranslatedProperties(this.getAppProperties());
    }

    protected XMLReader createXMLReader() {
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (SecurityException x) {
            String className = this.getUserProperties().getProperty("SAXParser", "org.apache.crimson.parser.XMLReaderImpl");
            return (XMLReader)Application.createObjectFromProperty(className, XMLReader.class);
        }
        catch (Exception x) {
            throw new RuntimeException("Error creating XML Parser", x);
        }
    }

    protected XMLMenuBuilder createXMLMenuBuilder() {
        this.setStatusMessage("Adding menus");
        URL xml = PropertyUtilities.getURL(this.getUserProperties(), "menuXML", null);
        if (xml == null) {
            throw new InitializationException("menuXML file not found");
        }
        try {
            ApplicationXMLMenuBuilder builder = new ApplicationXMLMenuBuilder();
            XMLReader reader = this.createXMLReader();
            builder.build(xml, reader);
            return builder;
        }
        catch (IOException x) {
            throw new InitializationException("IO Exception while reading " + xml, x);
        }
        catch (SAXException x) {
            throw new InitializationException("XML Exception while reading " + xml, x);
        }
    }

    public XMLMenuBuilder getXMLMenuBuilder() throws InitializationException {
        if (this.xmlMenuBuilder == null) {
            this.xmlMenuBuilder = this.createXMLMenuBuilder();
        }
        return this.xmlMenuBuilder;
    }

    public final Properties getAppProperties() {
        if (this.appProperties == null) {
            this.appProperties = this.createAppProperties();
        }
        return this.appProperties;
    }

    protected Properties createAppProperties() throws InitializationException {
        PropertyUtilities.TranslatedProperties prop;
        try {
            prop = new PropertyUtilities.TranslatedProperties(System.getProperties());
        }
        catch (SecurityException x) {
            prop = new PropertyUtilities.TranslatedProperties();
        }
        prop.setProperty("appName", this.appName);
        try {
            this.loadDefaultProperties(prop);
            String propFile = this.appName + ".properties";
            InputStream in = this.getClass().getResourceAsStream(propFile);
            if (in != null) {
                prop.load(in);
                in.close();
            }
            return prop;
        }
        catch (IOException x) {
            throw new InitializationException("Error initializing appplication properties", x);
        }
    }

    protected void loadDefaultProperties(Properties app) throws IOException {
        InputStream in = Application.class.getResourceAsStream("Default.properties");
        app.load(in);
        in.close();
    }

    public String getAppName() {
        return this.appName;
    }

    private static Object createObjectFromProperty(String className, Class type) throws InitializationException {
        try {
            Class<?> klass = Class.forName(className);
            if (!type.isAssignableFrom(klass)) {
                throw new InitializationException("Class " + className + " is not of type " + type);
            }
            return klass.newInstance();
        }
        catch (InitializationException x) {
            throw x;
        }
        catch (Throwable t) {
            throw new InitializationException("Error creating " + className, t);
        }
    }

    public void addApplicationListener(ApplicationListener l) {
        this.listenerList.add(ApplicationListener.class, l);
    }

    public void removeApplicationListener(ApplicationListener l) {
        this.listenerList.remove(ApplicationListener.class, l);
    }

    protected void fireInitializationComplete(ApplicationEvent event) {
        if (this.listenerList.getListenerCount(ApplicationListener.class) > 0) {
            ApplicationListener[] listener = (ApplicationListener[])this.listenerList.getListeners(ApplicationListener.class);
            for (int i = 0; i < listener.length; ++i) {
                listener[i].initializationComplete(event);
            }
        }
    }

    protected void fireApplicationVisible(ApplicationEvent event) {
    }

    protected void fireAboutToExit(ApplicationEvent event) {
        if (this.listenerList.getListenerCount(ApplicationListener.class) > 0) {
            ApplicationListener[] listener = (ApplicationListener[])this.listenerList.getListeners(ApplicationListener.class);
            for (int i = 0; i < listener.length; ++i) {
                listener[i].aboutToExit(event);
            }
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (!this.statusBarVisible && this.statusBar != null) {
            Application.updateComponentTreeUI(this.statusBar);
        }
        if (!this.toolBarVisible && this.toolBarHolder != null) {
            Application.updateComponentTreeUI(this.toolBarHolder);
        }
    }

    public static void updateComponentTreeUI(Component c) {
        Application.updateComponentTreeUI0(c);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    private static void updateComponentTreeUI0(Component c) {
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                Application.updateComponentTreeUI0(children[i]);
            }
        }
        if (c instanceof JComponent) {
            ((JComponent)c).updateUI();
        }
    }

    public class AppPrintPreview
    extends PrintPreview {
        @Override
        public void setPrintable(Printable painter) throws PrinterException {
            this.setPrintable(painter, Application.this.getServiceManager().getDefaultPage());
        }

        @Override
        protected boolean onPrint(Pageable document) throws PrinterException {
            return Application.this.getServiceManager().print(document);
        }

        @Override
        protected void onError(PrinterException x) {
            Application.error(this, "Print Error", x);
        }
    }

    public static interface InitializationListener {
        public void setStage(String var1);

        public void failed(Throwable var1);

        public void succeeded();
    }

    public static class InitializationException
    extends RuntimeException {
        public InitializationException(String message, Throwable detail) {
            super(message, detail);
        }

        public InitializationException(String message) {
            super(message);
        }
    }

    private class ApplicationXMLMenuBuilder
    extends XMLMenuBuilder {
        private ApplicationXMLMenuBuilder() {
        }

        protected JMenuItem createMenuItem(String className, String name, String type, String command) throws SAXException {
            JMenuItem result = super.createMenuItem(className, name, type, command);
            Application.this.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)result));
            return result;
        }

        protected AbstractButton createToolBarItem(String className, String name, String type, String command) throws SAXException {
            AbstractButton result = super.createToolBarItem(className, name, type, command);
            Application.this.getCommandTargetManager().add((CommandSource)new CommandSourceAdapter(result));
            return result;
        }
    }

    protected class ApplicationCommandTargetManager
    extends CommandTargetManager {
        protected ApplicationCommandTargetManager() {
        }

        public void handleCommandError(Throwable t) {
            Application.this.error("Error during command processing", t);
        }
    }

    public class ApplicationCommandProcessor
    extends CommandProcessor {
        public void onExit() {
            Application.this.exit();
        }

        public void onAbout() {
            Application.this.about();
        }

        public void onHelpContents() {
            Application.this.showHelpContents();
        }

        public void onHelpSearch() {
            Application.this.showHelpSearch();
        }

        public void onHelpIndex() {
            Application.this.showHelpIndex();
        }

        public void onShowStatusBar(boolean show) {
            Application.this.setShowStatusBar(show);
        }

        public void enableShowStatusBar(BooleanCommandState state) {
            state.setSelected(Application.this.statusBarVisible);
            state.setEnabled(true);
        }

        public void onShowToolBar(boolean show) {
            Application.this.setShowToolBar(show);
        }

        public void enableShowToolBar(BooleanCommandState state) {
            state.setSelected(Application.this.toolBarVisible);
            state.setEnabled(Application.this.toolBarHolder != null);
        }

        public CommandTarget acceptCommand(String command) {
            CommandTarget retValue = super.acceptCommand(command);
            if (retValue != null) {
                return retValue;
            }
            return super.acceptCommand(Application.getApplication().getClass(), command);
        }

        protected void invoke(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            if (method.getDeclaringClass().isInstance(Application.getApplication())) {
                method.invoke((Object)Application.getApplication(), args);
            } else {
                super.invoke(method, args);
            }
        }
    }

    private class DefaultInitializationListener
    implements InitializationListener {
        private DefaultInitializationListener() {
        }

        @Override
        public void setStage(String message) {
            System.out.println(message);
        }

        @Override
        public void failed(Throwable t) {
            System.out.println("Initialization failed " + t);
        }

        @Override
        public void succeeded() {
            System.out.println("Initialization complete");
        }
    }
}

