/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.ArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.scripting.ScriptingTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Names;

public abstract class CCS {
    private static boolean throwExceptions = true;
    private static ArrayList<ScriptingStatusBusListenerWrapper> listeners = new ArrayList();
    private static Logger logger = Logger.getLogger((String)"org.lsst.ccs.scripting");
    private static final MessagingFactory fac = MessagingFactory.getInstance().forSubsystem(Names.almostUniqueAgentName((String)"CCS-script"));

    private CCS() {
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        CCS.throwExceptions = throwExceptions;
    }

    public static boolean getThrowExceptions() {
        return throwExceptions;
    }

    public static ScriptingSubsystemWrapper attachSubsystem(String subsystemName) throws RuntimeException {
        return new ScriptingSubsystemWrapper(subsystemName);
    }

    public static void addStatusBusListener(ScriptingStatusBusListener listener) {
        ScriptingStatusBusListenerWrapper busListener = new ScriptingStatusBusListenerWrapper(listener);
        listeners.add(busListener);
        logger.finest((Object)("Adding listener " + listeners.size()), new String[0]);
        fac.addStatusListener((StatusListens)busListener, "");
    }

    public static void removeStatusBusListener(ScriptingStatusBusListener listener) {
        for (ScriptingStatusBusListenerWrapper l : listeners) {
            if (l.getScriptingStatusBusListener() != listener) continue;
            fac.removeStatusListener((StatusListens)l);
            listeners.remove(l);
            logger.finest((Object)("Removed listener " + listeners.size()), new String[0]);
            return;
        }
        logger.warning((Object)("Could not remove listener " + listener), new String[0]);
    }

    public static ScriptingStatusBusMessage waitForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) throws ScriptingTimeoutException {
        SynchronousQueue<ScriptingStatusBusMessage> synchQueue = new SynchronousQueue<ScriptingStatusBusMessage>();
        ScriptingStatusBusListenerImpl innerListener = new ScriptingStatusBusListenerImpl(filter, synchQueue);
        CCS.addStatusBusListener(innerListener);
        ScriptingStatusBusMessage reply = null;
        try {
            try {
                reply = synchQueue.poll(timeout, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
                CCS.removeStatusBusListener(innerListener);
            }
        }
        finally {
            CCS.removeStatusBusListener(innerListener);
        }
        return reply;
    }

    static class ScriptingStatusBusListenerImpl
    implements ScriptingStatusBusListener {
        private ScriptingStatusBusMessageFilter filter;
        private SynchronousQueue<ScriptingStatusBusMessage> queue;

        ScriptingStatusBusListenerImpl(ScriptingStatusBusMessageFilter filter, SynchronousQueue<ScriptingStatusBusMessage> queue) {
            this.filter = filter;
            this.queue = queue;
        }

        @Override
        public void onStatusBusMessage(ScriptingStatusBusMessage bm) {
            if (this.filter.accept(bm)) {
                logger.finest((Object)("Found match with " + bm), new String[0]);
                this.queue.offer(bm);
            }
        }
    }

    static class ScriptingStatusBusListenerWrapper
    implements StatusListener {
        private ScriptingStatusBusListener scriptingListener;

        ScriptingStatusBusListenerWrapper(ScriptingStatusBusListener scriptingListener) {
            this.scriptingListener = scriptingListener;
        }

        public void onStatus(BusMessage bm) {
            this.scriptingListener.onStatusBusMessage(new ScriptingStatusBusMessage(bm));
        }

        protected ScriptingStatusBusListener getScriptingStatusBusListener() {
            return this.scriptingListener;
        }
    }
}

