/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.beanutils.BeanUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.framework.Constraint;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.MethodConstraint;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

@Aspect
public class ConstraintAspect {
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.bus.framework.contraints");
    static Set<Constraint> constraints = new HashSet<Constraint>();
    protected Context context;
    static volatile int i = 0;
    static ReentrantLock lock = new ReentrantLock();

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void init() {
        String nameOfFile;
        log.debug((Object)"pointcut initialization started", new String[0]);
        this.getContext().getSubsystem();
        final String configFile = nameOfFile = null;
        try {
            String line;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            InputStream xsl2spring = this.getClass().getResourceAsStream("/org/lsst/ccs/framework/xsl/desc2constraint.xsl");
            final Transformer transformer = tFactory.newTransformer(new StreamSource(xsl2spring));
            final PipedOutputStream pipeOut = new PipedOutputStream();
            PipedInputStream pipeIn = new PipedInputStream(pipeOut);
            new Thread(){

                @Override
                public void run() {
                    try {
                        StreamSource ss = new StreamSource(BootstrapResourceUtils.getBootstrapResource((String)configFile));
                        transformer.transform(ss, new StreamResult(pipeOut));
                        pipeOut.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            BufferedReader configDesc = new BufferedReader(new InputStreamReader(pipeIn));
            while ((line = configDesc.readLine()) != null) {
                String[] words = line.trim().split(" +");
                if (words.length < 1) continue;
                Constraint c = null;
                String[] stringArray = words;
                int n = words.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    if (c == null) {
                        c = (Constraint)Class.forName(word).newInstance();
                    } else {
                        int ii = word.indexOf("=");
                        String prop = word.substring(0, ii);
                        String val = word.substring(ii + 1);
                        if (val.startsWith("\"")) {
                            val = val.substring(1, val.length() - 1);
                        }
                        BeanUtils.setProperty((Object)c, (String)prop, (Object)val);
                    }
                    ++n2;
                }
                constraints.add(c);
                log.debug((Object)("adding constraint " + c), new String[0]);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"error instanciating Aspect", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        log.debug((Object)"pointcut initialized", new String[0]);
    }

    @Pointcut(value="execution(@org.lsst.ccs.framework.Guarded * *.*(..))")
    public void pointcutGuarded() {
    }

    @Around(value="pointcutGuarded()")
    public Object checkConstraints(ProceedingJoinPoint pjp) throws Throwable {
        try {
            Object retVal;
            lock.lock();
            Object target = pjp.getTarget();
            String methName = pjp.getSignature().getName();
            if (!(target instanceof Module)) {
                log.debug((Object)("target " + target + " is not a module"), new String[0]);
                return null;
            }
            Module m = (Module)target;
            for (Constraint c : constraints) {
                MethodConstraint mc;
                if (!(c instanceof MethodConstraint) || !(mc = (MethodConstraint)c).isApplicable(target, methName) || mc.isVerified(m.getContext())) continue;
                log.debug((Object)("rejecting " + m.getName() + "." + methName), new String[0]);
                throw new RuntimeException("operation " + methName + " on " + target + " forbidden");
            }
            Object object = retVal = pjp.proceed();
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

