/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class StringTokenizer {
    StringTokenizer() {
    }

    public static List<Token> tokenize(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (input == null) {
            return result;
        }
        State state = State.WHITESPACE;
        int tokenIndex = -1;
        StringBuilder token = new StringBuilder("");
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            switch (state) {
                case WHITESPACE: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        state = State.WORD;
                        tokenIndex = i;
                        token.append(ch);
                        break;
                    }
                    if (ch == '\"') {
                        state = State.STRINGDQ;
                        tokenIndex = i;
                        break;
                    }
                    if (ch == '\'') {
                        state = State.STRINGSQ;
                        tokenIndex = i;
                        break;
                    }
                    if (ch == '#') {
                        state = State.COMMENT;
                        break;
                    }
                    state = State.WORD;
                    tokenIndex = i;
                    token.append(ch);
                    break;
                }
                case WORD: {
                    if (Character.isWhitespace(ch)) {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = State.WHITESPACE;
                        break;
                    }
                    if (ch == '#') {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = State.COMMENT;
                        break;
                    }
                    token.append(ch);
                    break;
                }
                case STRINGDQ: {
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            break;
                        }
                        state = State.WORD;
                        break;
                    }
                    token.append(ch);
                    break;
                }
                case STRINGSQ: {
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            break;
                        }
                        state = State.WORD;
                        break;
                    }
                    token.append(ch);
                    break;
                }
                case COMMENT: {
                    break;
                }
                default: {
                    assert (false) : "Unknown state in StringTokenizer state machine";
                    break;
                }
            }
            ++i;
        }
        if (state == State.WORD || state == State.STRINGDQ || state == State.STRINGSQ) {
            result.add(new Token(tokenIndex, token.toString()));
        }
        return result;
    }

    private static enum State {
        WHITESPACE,
        WORD,
        STRINGDQ,
        STRINGSQ,
        COMMENT;

    }

    static class Token
    implements Serializable {
        private int location;
        private String string;

        Token(int location, String string) {
            this.location = location;
            this.string = string;
        }

        int getLocation() {
            return this.location;
        }

        String getString() {
            return this.string;
        }
    }
}

