/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import java.util.Arrays;
import java.util.List;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.SystemCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.framework.CommandPresenceAgent;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.tracers.Names;
import org.lsst.ccs.utilities.tracers.Tracer;

public class BaseConsole
extends BusMaster {
    MessagingFactory localMessagingFactory;
    SynchronousCommandAgent syncAgent;
    Long defaultTimeOut = Long.getLong("timeout", 2000L);
    CommandPresenceAgent presenceAgent;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !BaseConsole.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Tracer.version((String)"$Rev: 30943 $", BaseConsole.class, (String)"org-lsst-ccs-subsystem-console")) {
            throw new AssertionError();
        }
    }

    public BaseConsole(String name) {
        name = name == null || name.length() == 0 ? Names.almostUniqueAgentName((String)"console") : "console_" + name;
        this.setName(name);
        this.localMessagingFactory = MessagingFactory.getInstance().forSubsystem(name);
        this.syncAgent = new SynchronousCommandAgent(this.localMessagingFactory);
        this.setStatusBroadcastPeriod(0);
        this.presenceAgent = new CommandPresenceAgent(this.localMessagingFactory);
    }

    public BaseConsole() {
        this(null);
    }

    protected void message(String str, boolean isError) {
        (isError ? System.err : System.out).println(str);
    }

    protected void messageFromBus(String message) {
        System.out.println(message);
    }

    protected void execute(String commandLine) {
        String[] words = commandLine.trim().split(" +");
        if (words.length < 1) {
            return;
        }
        switch (words[0]) {
            case "?": 
            case "help": {
                this.executeHelp(words);
                break;
            }
            case "lock": {
                this.executeLock(words);
                break;
            }
            case "unlock": {
                this.executeUnlock(words);
                break;
            }
            case "config": {
                this.executeConfig(words);
                break;
            }
            case "invoke": {
                this.executeInvoke(words, false);
                break;
            }
            case "syncInvoke": {
                this.executeSyncInvoke(words, false);
                break;
            }
            case "configSet": {
                this.executeConfigSet(words);
                break;
            }
            case "configTag": {
                this.executeConfigTag(words);
                break;
            }
            case "configDrop": {
                this.executeConfigDrop(words);
                break;
            }
            case "abort": {
                this.executeAbort(words);
                break;
            }
            case "signal": {
                this.executeSignal(words);
                break;
            }
            case "listSubsystems": {
                this.executeListSubsystems(words);
                break;
            }
            default: {
                this.executeRawSystemCommand(words);
            }
        }
    }

    private Object parse(String s) {
        if (s.startsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        }
        if (s.matches("-?[0-9]*[.][0-9]*|-?[0-9]*[.][0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        }
        return s;
    }

    private void executeHelp(String[] words) {
        block43: {
            String helpMessage;
            block42: {
                if (words.length != 1) break block42;
                String helpMessage2 = "usage: help commandName\n\tavailable commands: \n\t\tlock\n\t\tunlock\n\t\tconfig\n\t\tconfigSet\n\t\tconfigTag\n\t\tconfigDrop\n\t\tinvoke\n\t\tsyncInvoke\n\t\tabort\n\t\tsignal\n\t\tlistSubsystems\n\t+ <any subsystem command> subsystemName [arguments...]\n";
                this.message(helpMessage2, false);
                break block43;
            }
            switch (words[1]) {
                case "?": 
                case "help": {
                    helpMessage = " just type help without argument";
                    break;
                }
                case "lock": {
                    helpMessage = "gets a lock for a subsystem";
                    break;
                }
                case "unlock": {
                    helpMessage = "unlocks access to a subsystme";
                    break;
                }
                case "config": {
                    helpMessage = "lower level command for configSet, configTag, configDrop";
                    break;
                }
                case "configSet": {
                    helpMessage = "sets a new parameter value in the configuration context";
                    break;
                }
                case "configTag": {
                    helpMessage = "tags the current configuration context";
                    break;
                }
                case "configDrop": {
                    helpMessage = "drops the current configuraiton context";
                    break;
                }
                case "invoke": {
                    helpMessage = "invokes a command asynchronously";
                    break;
                }
                case "syncInvoke": {
                    helpMessage = "invokes a command synchronously";
                    break;
                }
                case "abort": {
                    helpMessage = "halts a subsystem as soon as possible (urgent situation)";
                    break;
                }
                case "signal": {
                    helpMessage = "sends a signal to a component";
                    break;
                }
                case "listSubsystems": {
                    String helpMessage3 = "list the subsystems on the command bus (usage : listSubsystems [master] [slave])";
                    this.message(helpMessage3, false);
                    return;
                }
                default: {
                    helpMessage = "unknown command (are you asking for a command specific to a subsystem dictionary?)";
                }
            }
            helpMessage = String.valueOf(helpMessage) + "\n\tfor more details about arguments type the command without any argument";
            this.message(helpMessage, false);
        }
    }

    private void executeConfig(String[] words) {
        String usageMessage = "usages: config target set parameterName value\nconfig target tag configurationName  [optionalTag]\nconfig target drop";
        if (words.length < 3) {
            this.message(usageMessage, true);
        } else {
            String operation = words[2];
            String[] arguments = new String[words.length - 1];
            arguments[1] = words[1];
            if (words.length > 3) {
                int ix = 3;
                while (ix < words.length) {
                    arguments[ix - 1] = words[ix];
                    ++ix;
                }
            }
            if ("set".equals(operation)) {
                this.executeConfigSet(arguments);
            } else if ("tag".equals(operation)) {
                this.executeConfigTag(arguments);
            } else if ("drop".equals(operation)) {
                this.executeConfigDrop(arguments);
            } else {
                this.message(usageMessage, true);
            }
        }
    }

    private void executeInvoke(String[] words, boolean force) {
        if (words.length < 3) {
            this.message("usage: invoke target name [params...]", true);
        } else {
            String dest = words[1];
            String name = words[2];
            int n = words.length - 3;
            Object[] p = new Object[n];
            int i = 0;
            while (i < n) {
                p[i] = this.parse(words[3 + i]);
                ++i;
            }
            ModuleInvokerCommand cmd = new ModuleInvokerCommand(name, p);
            cmd.setDestination(dest);
            cmd.setCanRunInActiveMode(force);
            try {
                this.localMessagingFactory.sendCommand((Command)cmd);
            }
            catch (Exception exc) {
                this.message("send error: " + StackTraceFormats.toString((Throwable)exc), true);
            }
        }
    }

    private void executeSyncInvoke(String[] words, boolean force) {
        if (words.length < 4) {
            this.message("usage: syncInvoke timeout target name [params...])", true);
        } else {
            long timeout = Long.parseLong(words[1]);
            String dest = words[2];
            String name = words[3];
            int n = words.length - 4;
            Object[] p = new Object[n];
            int i = 0;
            while (i < n) {
                p[i] = this.parse(words[4 + i]);
                ++i;
            }
            ModuleInvokerCommand cmd = new ModuleInvokerCommand(name, p);
            cmd.setDestination(dest);
            cmd.setCanRunInActiveMode(force);
            try {
                Object res = this.syncAgent.invoke((Command)cmd, timeout);
                String strRes = null;
                if (res instanceof Exception) {
                    strRes = StackTraceFormats.toString((Throwable)((Exception)res));
                    this.message("error?: " + strRes, true);
                } else if (res == null) {
                    strRes = "ok : VOID";
                    this.message(strRes, false);
                } else {
                    strRes = String.valueOf(res);
                    this.message("result: " + strRes, false);
                }
            }
            catch (Exception e) {
                this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e), true);
            }
        }
    }

    private void executeConfigSet(String[] words) {
        if (words.length != 4) {
            this.message(" usage : configSet destination parameterName value", true);
            return;
        }
        String destination = words[1];
        String parameterName = words[2];
        String value = words[3];
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("change", new Object[]{parameterName, value});
        cmd.setDestination(destination);
        try {
            Object res = this.syncAgent.invoke((Command)cmd, this.defaultTimeOut.longValue());
            if (res instanceof Exception) {
                String strRes = StackTraceFormats.toString((Throwable)((Exception)res));
                this.message("error?: " + strRes, true);
            } else {
                String strRes = String.valueOf(res);
                this.message("result: " + strRes, false);
            }
        }
        catch (Exception e) {
            this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e), true);
        }
    }

    private void executeConfigTag(String[] words) {
        if (words.length < 3) {
            this.message(" usage : configTag subsystemName configName [optionalTag]", true);
            return;
        }
        String destination = words[1];
        int index = destination.indexOf(47);
        if (-1 != index) {
            destination = destination.substring(0, index);
        }
        String configName = words[2];
        String tagName = "";
        if (words.length > 3) {
            tagName = words[3];
        }
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("register", new Object[]{configName, tagName});
        cmd.setDestination(destination);
        try {
            Object res = this.syncAgent.invoke((Command)cmd, this.defaultTimeOut.longValue());
            if (res == null) {
                this.message("ok", false);
            } else {
                this.message("error?: " + StackTraceFormats.toString((Throwable)((Exception)res)), true);
            }
        }
        catch (Exception e) {
            this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e), true);
        }
    }

    private void executeConfigDrop(String[] words) {
        if (words.length < 2) {
            this.message(" usage : configDrop subsystemName ", true);
            return;
        }
        String destination = words[1];
        int index = destination.indexOf(47);
        if (-1 != index) {
            destination = destination.substring(0, index);
        }
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("dropConfigurationContext", new Object[0]);
        cmd.setDestination(destination);
        try {
            Object res = this.syncAgent.invoke((Command)cmd, this.defaultTimeOut.longValue());
            if (res == null) {
                this.message("ok", false);
            } else {
                this.message("error?: " + StackTraceFormats.toString((Throwable)((Exception)res)), true);
            }
        }
        catch (Exception e) {
            this.message(" Exception caught :" + StackTraceFormats.toString((Throwable)e), true);
        }
    }

    private void executeLock(String[] words) {
        if (words.length < 2) {
            this.message("usage: lock subsystemName", true);
        } else {
            this.lockSubsystem(words[1]);
        }
    }

    private void executeUnlock(String[] words) {
        if (words.length < 2) {
            this.message("usage: unlock subsystemName", true);
        } else {
            this.unlockSubsystem(words[1]);
        }
    }

    private void executeSignal(String[] words) {
        if (words.length < 3) {
            this.message(" usage : signal goalName signalName [expectedMaxDelay]", true);
            return;
        }
        String destination = words[1];
        int n = words.length - 2;
        Object[] p = new Object[n];
        int i = 0;
        while (i < n) {
            p[i] = this.parse(words[2 + i]);
            ++i;
        }
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("sendSignal", p);
        cmd.setCanRunInActiveMode(true);
        cmd.setDestination(destination);
        try {
            this.localMessagingFactory.sendCommand((Command)cmd);
        }
        catch (Exception exc) {
            this.message("send error: " + StackTraceFormats.toString((Throwable)exc), true);
        }
    }

    private void executeAbort(String[] words) {
        if (words.length < 2) {
            this.message(" usage : abort subsystemName [expectedMaxDelay]", true);
            return;
        }
        String destination = words[1];
        int n = words.length - 2;
        Object[] p = new Object[n];
        int i = 0;
        while (i < n) {
            p[i] = this.parse(words[2 + i]);
            ++i;
        }
        SystemCommand cmd = new SystemCommand(destination, "abort", p);
        cmd.setCanRunInActiveMode(true);
        try {
            this.localMessagingFactory.sendCommand((Command)cmd);
        }
        catch (Exception exc) {
            this.message("send error: " + StackTraceFormats.toString((Throwable)exc), true);
        }
    }

    private void executeRawSystemCommand(String[] words) {
        if (words.length < 2) {
            this.message("unknown command [" + Arrays.toString(words) + "] now parsed as a Subsystem command but should be of the form <nameOfCommand> <subsystemName> [parameters]", true);
            return;
        }
        String destination = words[1];
        int n = words.length - 2;
        Object[] p = new Object[n];
        int i = 0;
        while (i < n) {
            p[i] = this.parse(words[2 + i]);
            ++i;
        }
        SystemCommand cmd = new SystemCommand(destination, words[0], p);
        cmd.setCanRunInActiveMode(true);
        cmd.setDestination(destination);
        try {
            this.localMessagingFactory.sendCommand((Command)cmd);
        }
        catch (Exception exc) {
            this.message("send error: " + StackTraceFormats.toString((Throwable)exc), true);
        }
    }

    private void executeListSubsystems(String[] words) {
        boolean master = false;
        boolean slave = false;
        switch (words.length) {
            case 1: {
                List list = this.presenceAgent.listAll();
                this.message(String.valueOf(list), false);
                break;
            }
            case 2: {
                List resList;
                String qualif;
                switch (qualif = words[1].toLowerCase()) {
                    case "master": {
                        resList = this.presenceAgent.listMasters();
                        break;
                    }
                    case "slave": {
                        resList = this.presenceAgent.listSlaves();
                        break;
                    }
                    default: {
                        this.message("cannot use : " + qualif + " as a single argument", true);
                        return;
                    }
                }
                this.message(String.valueOf(resList), false);
                break;
            }
            case 3: {
                String qualif1 = words[1].toLowerCase();
                String qualif2 = words[2].toLowerCase();
                switch (qualif1) {
                    case "master": {
                        master = true;
                        slave = qualif2.equals("slave");
                        break;
                    }
                    case "slave": {
                        slave = true;
                        master = qualif2.equals("master");
                        break;
                    }
                    default: {
                        slave = qualif2.equals("slave");
                        master = qualif2.equals("master");
                    }
                }
                List resList = this.presenceAgent.list(master, slave);
                this.message(String.valueOf(resList), false);
                break;
            }
            default: {
                this.message("usage : listSubsystems [master or noMaster] [slave or noSlave]", true);
            }
        }
    }

    public void onReply(CommandReply cmd) {
        String rep = "\nReply message from " + cmd.getOrigin();
        rep = String.valueOf(rep) + "\nCorrelID: " + cmd.getCorrelId();
        rep = String.valueOf(rep) + "\nStatus         : " + cmd.getStatus();
        Object res = cmd.getReply();
        rep = res instanceof Exception ? String.valueOf(rep) + "\nException:" + StackTraceFormats.toString((Throwable)((Exception)res)) : (res == null ? String.valueOf(rep) + "\nReply          : VOID" : String.valueOf(rep) + "\nReply          : " + res);
        this.messageFromBus(rep);
    }

    public void onAck(CommandAck cmd) {
        String rep = "\n" + cmd.toString();
        rep = String.valueOf(rep) + "\nCorrelId       : " + cmd.getCorrelId();
        this.messageFromBus(rep);
    }

    public MessagingFactory getMessagingFactory() {
        return this.localMessagingFactory;
    }
}

