/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFImageLoader;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.BitmapInfo;
import org.freehep.graphicsio.emf.gdi.BitmapInfoHeader;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.io.NoCloseOutputStream;

public class BitBlt
extends EMFTag
implements EMFConstants {
    private static final int size = 100;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private int dwROP;
    private int xSrc;
    private int ySrc;
    private AffineTransform transform;
    private Color bkg;
    private int usage;
    private BitmapInfo bmi;
    private BufferedImage image;

    public BitBlt() {
        super(76, 1);
    }

    public BitBlt(Rectangle bounds, int x, int y, int width, int height, AffineTransform transform, BufferedImage image, Color bkg) {
        this();
        this.bounds = bounds;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dwROP = 0xCC0020;
        this.xSrc = 0;
        this.ySrc = 0;
        this.transform = transform;
        this.bkg = bkg;
        this.usage = 0;
        this.image = image;
        this.bmi = null;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        BitBlt tag = new BitBlt();
        tag.bounds = emf.readRECTL();
        tag.x = emf.readLONG();
        tag.y = emf.readLONG();
        tag.width = emf.readLONG();
        tag.height = emf.readLONG();
        tag.dwROP = emf.readDWORD();
        tag.xSrc = emf.readLONG();
        tag.ySrc = emf.readLONG();
        tag.transform = emf.readXFORM();
        tag.bkg = emf.readCOLORREF();
        tag.usage = emf.readDWORD();
        emf.readDWORD();
        int bmiSize = emf.readDWORD();
        emf.readDWORD();
        int bitmapSize = emf.readDWORD();
        tag.bmi = bmiSize > 0 ? new BitmapInfo(emf) : null;
        tag.image = bitmapSize > 0 && tag.bmi != null ? EMFImageLoader.readImage(tag.bmi.getHeader(), tag.width, tag.height, emf, bitmapSize, null) : null;
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeLONG(this.x);
        emf.writeLONG(this.y);
        emf.writeLONG(this.width);
        emf.writeLONG(this.height);
        emf.writeDWORD(this.dwROP);
        emf.writeLONG(this.xSrc);
        emf.writeLONG(this.ySrc);
        emf.writeXFORM(this.transform);
        emf.writeCOLORREF(this.bkg);
        emf.writeDWORD(this.usage);
        emf.writeDWORD(100);
        emf.writeDWORD(40);
        emf.writeDWORD(140);
        emf.pushBuffer();
        UserProperties properties = new UserProperties();
        properties.setProperty(RawImageWriteParam.BACKGROUND, this.bkg);
        properties.setProperty(RawImageWriteParam.CODE, "BGR");
        properties.setProperty(RawImageWriteParam.PAD, 4);
        ImageGraphics2D.writeImage((RenderedImage)this.image, (String)"raw", (Properties)properties, (OutputStream)new NoCloseOutputStream((OutputStream)((Object)emf)));
        int length = emf.popBuffer();
        BitmapInfoHeader header = new BitmapInfoHeader(this.image.getWidth(), this.image.getHeight(), 24, 0, length, 0, 0, 0, 0);
        this.bmi = new BitmapInfo(header);
        this.bmi.write(emf);
        emf.writeDWORD(length);
        emf.append();
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  dwROP: 0x" + Integer.toHexString(this.dwROP) + "\n  xSrc, ySrc: " + this.xSrc + " " + this.ySrc + "\n  transform: " + this.transform + "\n  bkg: " + this.bkg + "\n  usage: " + this.usage + "\n" + (this.bmi != null ? this.bmi.toString() : "  bitmap: null");
    }

    public void render(EMFRenderer renderer) {
        if (this.image != null) {
            renderer.drawImage(this.image, this.transform);
        }
    }
}

