/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.text.MessageFormat;
import java.text.ParseException;

public class NumberedStringGenerator {
    private MessageFormat messageFormat;
    private int max = -1;
    private int min = -1;

    public NumberedStringGenerator(String simplePattern) {
        if (-1 == simplePattern.indexOf("#")) {
            throw new IllegalArgumentException("no # in simplePattern String");
        }
        String realPattern = simplePattern.replace("#", "{0,number,integer}");
        this.messageFormat = new MessageFormat(realPattern);
    }

    public boolean submit(String candidate) {
        try {
            Object[] parsed = this.messageFormat.parse(candidate);
            int val = ((Long)parsed[0]).intValue();
            if (val > this.max) {
                this.max = val;
            }
            if (this.min == -1) {
                this.min = val;
            } else if (val < this.min) {
                this.min = val;
            }
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public String getNewString() {
        return this.messageFormat.format(new Integer[]{this.max + 1});
    }

    public String getMaxString() {
        return this.messageFormat.format(new Integer[]{this.max});
    }

    public int getMax() {
        return this.max;
    }

    public String getMinString() {
        if (this.min == -1) {
            return null;
        }
        return this.messageFormat.format(new Integer[]{this.min});
    }

    public String formatWith(int number) {
        return this.messageFormat.format(new Integer[]{number});
    }
}

