/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import java.util.ArrayList;
import org.freehep.jas.services.PlotterAdapter;

public class PlotterAdapterLookup {
    private ArrayList adapters = new ArrayList();

    public void registerAdapter(PlotterAdapter adapter, Class from, Class to) {
        this.adapters.add(new AdapterEntry(adapter, from, to));
    }

    public PlotterAdapter adapter(Class from, Class to) {
        int i;
        ArrayList<AdapterEntry> fromAdapters = new ArrayList<AdapterEntry>();
        ArrayList<AdapterEntry> toAdapters = new ArrayList<AdapterEntry>();
        for (i = 0; i < this.adapters.size(); ++i) {
            AdapterEntry entry = (AdapterEntry)this.adapters.get(i);
            if (entry.isAdapter(from, to)) {
                return entry.adapter();
            }
            if (entry.isAdapterFrom(from)) {
                fromAdapters.add(entry);
            }
            if (!entry.isAdapterTo(to)) continue;
            toAdapters.add(entry);
        }
        if (fromAdapters.size() == 0 || toAdapters.size() == 0) {
            return null;
        }
        for (i = 0; i < fromAdapters.size(); ++i) {
            AdapterEntry fromEntry = (AdapterEntry)fromAdapters.get(i);
            for (int j = 0; j < toAdapters.size(); ++j) {
                AdapterEntry toEntry = (AdapterEntry)toAdapters.get(j);
                if (!fromEntry.isAdapterTo(toEntry.from())) continue;
                CombinedAdapter combinedAdapter = new CombinedAdapter(fromEntry.adapter(), toEntry.adapter());
                return combinedAdapter;
            }
        }
        return null;
    }

    private class CombinedAdapter
    implements PlotterAdapter {
        private PlotterAdapter fromAdapter;
        private PlotterAdapter toAdapter;
        private PlotterAdapter inBetweenAdapter;

        public CombinedAdapter(PlotterAdapter fromAdapter, PlotterAdapter toAdapter) {
            this.fromAdapter = fromAdapter;
            this.toAdapter = toAdapter;
        }

        public CombinedAdapter(PlotterAdapter fromAdapter, PlotterAdapter inBetweenAdapter, PlotterAdapter toAdapter) {
            this.fromAdapter = fromAdapter;
            this.toAdapter = toAdapter;
            this.inBetweenAdapter = inBetweenAdapter;
        }

        @Override
        public Object adapt(Object obj) {
            if (this.inBetweenAdapter == null) {
                return this.toAdapter.adapt(this.fromAdapter.adapt(obj));
            }
            System.out.println("** " + this.fromAdapter);
            System.out.println("** " + this.inBetweenAdapter);
            System.out.println("** " + this.toAdapter);
            return this.toAdapter.adapt(this.inBetweenAdapter.adapt(this.fromAdapter.adapt(obj)));
        }
    }

    private class AdapterEntry {
        private PlotterAdapter adapter;
        private Class from;
        private Class to;
        private Class inBetween;

        public AdapterEntry(PlotterAdapter adapter, Class from, Class to) {
            this.adapter = adapter;
            this.from = from;
            this.to = to;
        }

        public PlotterAdapter adapter() {
            return this.adapter;
        }

        public Class from() {
            return this.from;
        }

        public Class to() {
            return this.to;
        }

        public boolean isAdapter(Class from, Class to) {
            return this.isAdapterFrom(from) && this.isAdapterTo(to);
        }

        public boolean isAdapterFrom(Class from) {
            return this.from().isAssignableFrom(from);
        }

        public boolean isAdapterTo(Class to) {
            return to.isAssignableFrom(this.to());
        }
    }
}

