/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class MemoryButton
extends JLabel
implements ActionListener,
ComponentListener {
    private static final boolean AUTOMATIC_REFRESH = true;
    private static final int TICK = 1000;
    private final Runtime r = Runtime.getRuntime();
    private final Format f = new MessageFormat(" {0,number,0.0}/{1,number,0.0}MB ");
    private final Timer t = new Timer(1000, this);
    private double proportion = 0.0;
    private double[] graph = null;
    private int graphPointer;
    private int graphBase;
    private boolean containsMouse = false;

    public MemoryButton() {
        this.enableEvents(16L);
        this.setText(this.f.format(new Object[]{new Double(999.0), new Double(999.0)}));
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.setToolTipText("Click to force garbage collection");
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension result = super.getMaximumSize();
        result.height = this.getParent().getHeight();
        return result;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getParent().addComponentListener(this);
        if (this.getParent().isVisible()) {
            this.t.start();
            this.update(false);
        }
    }

    @Override
    public void removeNotify() {
        this.getParent().removeComponentListener(this);
        this.t.stop();
        super.removeNotify();
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.t.start();
        this.update(false);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.t.stop();
    }

    private void update(boolean ticked) {
        long total = this.r.totalMemory();
        long used = total - this.r.freeMemory();
        this.proportion = (double)used / (double)total;
        if (ticked && this.graph != null) {
            this.graph[this.graphPointer] = this.proportion;
            this.graphPointer = (this.graphPointer + 1) % this.graph.length;
            if (this.graphPointer == this.graphBase) {
                this.graphBase = (this.graphPointer + 1) % this.graph.length;
            }
        }
        Double _total = new Double((double)total / 1024.0 / 1024.0);
        Double _used = new Double((double)used / 1024.0 / 1024.0);
        String text = this.f.format(new Object[]{_used, _total});
        this.setText(text);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        size.height -= 4;
        size.width -= 3;
        g.translate(3, 1);
        Color old = g.getColor();
        try {
            Color c = UIManager.getColor("controlShadow");
            g.setColor(c);
            int bufferLength = size.width - 2;
            if (this.graph == null) {
                this.graph = new double[bufferLength];
                this.graphPointer = 0;
                this.graphBase = 0;
            } else if (this.graph.length != bufferLength) {
                int oldLength = this.graph.length;
                double[] nue = new double[bufferLength];
                int i = bufferLength;
                int j = this.graphPointer;
                while (j != this.graphBase && i > 0) {
                    j = (j + oldLength - 1) % oldLength;
                    nue[--i] = this.graph[j];
                }
                this.graph = nue;
                this.graphPointer = 0;
                this.graphBase = i % bufferLength;
            }
            int x = size.width - 3;
            int i = this.graphPointer;
            while (i != this.graphBase) {
                i = (i + bufferLength - 1) % bufferLength;
                double val = this.graph[i];
                int drawnVal = (int)((double)(size.height - 2) * val);
                g.drawLine(x, size.height - 1 - drawnVal, x, size.height - 1);
                --x;
            }
            c = this.containsMouse ? this.getBackground().brighter() : this.getBackground().darker();
            g.setColor(c);
            g.drawRect(0, 1, size.width - 2, size.height - 2);
            if (this.containsMouse) {
                g.drawRect(1, 2, size.width - 4, size.height - 4);
            }
        }
        finally {
            g.setColor(old);
            g.translate(-3, -1);
        }
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMouseEvent(MouseEvent me) {
        super.processMouseEvent(me);
        if (me.getID() == 500) {
            Graphics g = this.getGraphics();
            Color old = g.getColor();
            try {
                g.setColor(UIManager.getColor("info"));
                g.fillRect(0, 1, this.getWidth(), this.getHeight() - 1);
                g.setColor(UIManager.getColor("infoText"));
                g.setFont(this.getFont());
                FontMetrics fm = g.getFontMetrics();
                String text = "GC...";
                Rectangle textRect = new Rectangle();
                SwingUtilities.layoutCompoundLabel(fm, text, null, 0, 2, 0, 2, new Rectangle(), new Rectangle(), textRect, 0);
                g.drawString(text, textRect.x, textRect.y);
            }
            finally {
                g.setColor(old);
            }
            System.gc();
            this.repaint();
        } else if (me.getID() == 504) {
            this.setToolTipText("Click to force garbage collection [" + this.getText() + "]");
            this.containsMouse = true;
            this.repaint();
        } else if (me.getID() == 505) {
            this.containsMouse = false;
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update(true);
    }
}

