package org.lsst.ccs.plugin.jas3.tutorial;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.swing.popup.HasPopupItems;

/**
 * This is a more advanced tutorial page. This page listens for life-cycle notifications, has its
 * own popup menu, and various controls for closing itself.
 * @author tonyj
 */
public class AdvancedTutorialPage extends JPanel implements ManagedPage, HasPopupItems {
    private PageContext pageContext;
    private JCheckBox vetoCheckBox;
    private JTextField titleField;

     public AdvancedTutorialPage() {
        super(new BorderLayout());
        JEditorPane text = new JEditorPane("text/html",
                "I am an AdvancedTutorialPage. Close me using my popup menu, or by clicking the "
                + "x in my page tab or the close button below."
                + "<p>I print messages to standard output when I am selected or deselected which should be "
                + "trapped and appear in a console window below."
                + "<p>I have a custom popup menu with an extra item added."
                + "<p>You can veto close operations, and change my title using the controls at the bottom "
                + "of the page.");
        add(text,BorderLayout.CENTER);
        add(createControls(),BorderLayout.SOUTH);
    }

    @Override
    public boolean close() {
        // I am being asked to close, I can veto the request by returning false
        if (vetoCheckBox.isSelected()) {
            JOptionPane.showMessageDialog(this,"I refuse to close!");
            return false;
        }
        return true;
    }

    @Override
    public void setPageContext(PageContext pc) {
        this.pageContext = pc;
        titleField.setText(pc.getTitle());
        titleField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                updateTitle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                updateTitle();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                updateTitle();
            }

            private void updateTitle() {
                pageContext.setTitle(titleField.getText());
            }
        });

    }

    @Override
    public void pageSelected() {
        System.out.println("I've been selected");
    }

    @Override
    public void pageDeselected() {
        System.out.println("I've been deselected");
    }

    @Override
    public void pageIconized() {
        System.out.println("I've been iconized");
    }

    @Override
    public void pageDeiconized() {
        System.out.println("I've been de-iconized");
    }

    @Override
    public void pageClosed() {
        System.out.println("I've been closed");
    }

    @Override
    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        // Add a new item to the default popup menu.
        JMenuItem extra = new JMenuItem("Extra");
        extra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(AdvancedTutorialPage.this,"Extra menu item selected!");
            }
        });
        // Add at top of existing menu
        menu.insert(extra, 0);
        return menu;
    }

    // Create some demonstration fields at the bottom of the page. (In general I recommend
    // using a GUI builder to create controls, but this is just a demo so I wanted to keep
    // things simple.
    private JPanel createControls() {
        JPanel controls = new JPanel(new FlowLayout());
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pageContext.close();
            }
        });
        controls.add(closeButton);
        vetoCheckBox = new JCheckBox("Veto close");
        controls.add(vetoCheckBox);
        controls.add(new JLabel("Title:"));
        titleField = new JTextField(20);
        controls.add(titleField);
        return controls;
    }
    
}
