package org.lsst.ccs.plugin.jas3.elog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.DefaultListModel;
import javax.swing.*;
import org.lsst.ccs.elog.ELogConnectionUtils;
import org.lsst.ccs.elog.ElogEntry;
import org.lsst.ccs.elog.ElogTransactionResult;

/**
 *
 * @author turri
 */
public class LsstElogSubmissionDialog extends javax.swing.JPanel {

    private ElogEntry entry;
    private ArrayList<LsstElogAttachment> attachments = new ArrayList<>();
    private String version = "";
    private String category = "";
    private String select = "select";
    private String tagMessage;

    /**
     * Creates new form LsstElogSubmissionDialog
     */
    public LsstElogSubmissionDialog() {
        entry = new ElogEntry();
        //entry.setCategory("Testing");
        initComponents();

       
        versionComboBox.setModel(new javax.swing.DefaultComboBoxModel(extendArray(ELogConnectionUtils.getVersions())));

        // category and tags remain empty until eLog version is selected.
        categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        tagList.setModel(new DefaultListModel());

    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        categoryLabel = new javax.swing.JLabel();
        entryTextLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        entryTextArea = new javax.swing.JTextArea();
        attachmentsLabel = new javax.swing.JLabel();
        addAttachmentButton = new javax.swing.JButton();
        tagsLabel = new javax.swing.JLabel();
        titleLabel = new javax.swing.JLabel();
        submitEntryButton = new javax.swing.JButton();
        attachmentsPanel = new javax.swing.JPanel();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 32767));
        categoryComboBox = new javax.swing.JComboBox();
        versionLabel = new javax.swing.JLabel();
        versionComboBox = new javax.swing.JComboBox();
        jScrollPane2 = new javax.swing.JScrollPane();
        tagList = new javax.swing.JList();
        messageLabel = new javax.swing.JLabel();
        clearTagsButton = new javax.swing.JButton();
        clearFormButton = new javax.swing.JButton();

        setPreferredSize(new java.awt.Dimension(484, 280));

        categoryLabel.setText("Category:");

        entryTextLabel.setText("Entry Text:");

        entryTextArea.setColumns(20);
        entryTextArea.setRows(5);
        jScrollPane1.setViewportView(entryTextArea);

        attachmentsLabel.setText("Attachments:");

        addAttachmentButton.setText("Add Attachment ...");
        addAttachmentButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addAttachmentButtonActionPerformed(evt);
            }
        });

        tagsLabel.setText("List of Tags:");

        titleLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleLabel.setText("New Elog Entry Form");

        submitEntryButton.setText("Submit Elog Entry");
        submitEntryButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                submitEntryButtonActionPerformed(evt);
            }
        });

        attachmentsPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        attachmentsPanel.setAlignmentY(1.0F);
        attachmentsPanel.setMinimumSize(new java.awt.Dimension(40, 40));
        attachmentsPanel.setLayout(new javax.swing.BoxLayout(attachmentsPanel, javax.swing.BoxLayout.Y_AXIS));

        filler1.setAlignmentY(1.0F);
        filler1.setAutoscrolls(true);
        attachmentsPanel.add(filler1);

        categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        categoryComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                categoryComboBoxActionPerformed(evt);
            }
        });

        versionLabel.setText("eLog Version");

        versionComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        versionComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                versionComboBoxActionPerformed(evt);
            }
        });

        tagList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane2.setViewportView(tagList);

        messageLabel.setForeground(new java.awt.Color(215, 62, 34));
        messageLabel.setText(">");

        clearTagsButton.setText("Clear selected tags");
        clearTagsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearTagsButtonActionPerformed(evt);
            }
        });

        clearFormButton.setText("Clear Form");
        clearFormButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearFormButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(24, 24, 24)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(tagsLabel)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                    .addGap(45, 45, 45)
                                    .addComponent(versionLabel)))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                    .addComponent(jScrollPane2)
                                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                        .addGap(1, 1, 1)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(addAttachmentButton)
                                            .addComponent(submitEntryButton)))
                                    .addComponent(clearTagsButton, javax.swing.GroupLayout.Alignment.LEADING))
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(versionComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 214, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addGap(62, 62, 62)
                                                .addComponent(categoryLabel)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(categoryComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 231, javax.swing.GroupLayout.PREFERRED_SIZE))
                                            .addGroup(layout.createSequentialGroup()
                                                .addGap(19, 19, 19)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                    .addComponent(entryTextLabel)
                                                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 753, Short.MAX_VALUE)))))
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(25, 25, 25)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(messageLabel)
                                            .addComponent(attachmentsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                            .addComponent(attachmentsLabel)))))))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(324, 324, 324)
                        .addComponent(titleLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(clearFormButton)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(20, 20, 20)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(titleLabel)
                    .addComponent(clearFormButton))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(categoryLabel)
                    .addComponent(categoryComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(versionLabel)
                    .addComponent(versionComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(13, 13, 13)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(entryTextLabel, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(tagsLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1)
                        .addGap(36, 36, 36))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(clearTagsButton)
                        .addGap(33, 33, 33)))
                .addComponent(attachmentsLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(addAttachmentButton)
                    .addComponent(attachmentsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE))
                .addGap(10, 10, 10)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(submitEntryButton)
                    .addComponent(messageLabel)))
        );

        getAccessibleContext().setAccessibleName("");
    }// </editor-fold>//GEN-END:initComponents

    private void submitEntryButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_submitEntryButtonActionPerformed
        if ( version.equals("") || version.startsWith(select)) {
            messageLabel.setText("> Please select version and category");
            return;
        } else if ( category.equals("") || category.startsWith(select)) {
            messageLabel.setText("> Please select category");
            return;
        }
        messageLabel.setText(">");
        entry.setCategory(category);
        
        try {
            entry.setFormName("default");
            entry.setFormField("text", entryTextArea.getText());

            if (tagList.isSelectionEmpty() ) {
                tagMessage = "WARNING:  No tags selected. ";
                messageLabel.setText("> " + tagMessage);
            } else {
                tagMessage = "";
                for (Object selectedTag : tagList.getSelectedValuesList()) {
                    entry.addTag( (String) selectedTag);
                }
            }
            
            ElogTransactionResult result = ELogConnectionUtils.postEntryToElog(entry, version);
            entry.reset();
            SwingUtilities.invokeLater(new ClearDialog());
            messageLabel.setText("> " + tagMessage + "Entry submitted.");
        } catch (Exception e) {
            e.printStackTrace();
        }

    }//GEN-LAST:event_submitEntryButtonActionPerformed

    private void addAttachmentButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addAttachmentButtonActionPerformed
        messageLabel.setText(">");
        JFileChooser dlg = new JFileChooser();
        dlg.setDialogTitle("Select an Image");
        dlg.setApproveButtonText("Select");
        if (dlg.showOpenDialog(LsstElogSubmissionDialog.this) == JFileChooser.APPROVE_OPTION) {
            final File file = dlg.getSelectedFile();
            try {
                String fileName = file.getName();
                LsstElogAttachment attach = new LsstElogAttachment(fileName, ElogEntry.isFileImage(fileName), LsstElogSubmissionDialog.this);
                attachments.add(attach);
                entry.addFile(fileName, file);
                SwingUtilities.invokeLater(new AddAttachment(attach));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }//GEN-LAST:event_addAttachmentButtonActionPerformed

    private void categoryComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_categoryComboBoxActionPerformed
        messageLabel.setText(">");
        //entry.setCategory((String) categoryComboBox.getSelectedItem());
        category = (String) categoryComboBox.getSelectedItem();
        entry.setCategory(category);
        
        // Get the tags for this category. (Currently tags do not depend on category).
        try {
            List<String> tags = ELogConnectionUtils.getTags(version);
            DefaultListModel model = new DefaultListModel();
            tagList.setModel(model);
            for (String tag : tags) {
                model.addElement(tag);       
            }           
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }//GEN-LAST:event_categoryComboBoxActionPerformed

    private void versionComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_versionComboBoxActionPerformed
        messageLabel.setText(">");
        version = (String) versionComboBox.getSelectedItem();
        category = "";
        tagList.setModel(new DefaultListModel());
        if (version.startsWith(select)) {
            categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel());
            return;
            
        }
        
        // Get the categories from this eLog version.
        try {
            
            List<String> categories = ELogConnectionUtils.getCategories(version);
            String[] cats = new String[categories.size()];
            cats = categories.toArray(cats);
            categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel(extendArray(cats)));
            //categoryComboBox.setModel(new javax.swing.DefaultComboBoxModel(categories.toArray(cats)));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }//GEN-LAST:event_versionComboBoxActionPerformed

    private void clearTagsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearTagsButtonActionPerformed
        messageLabel.setText(">");
        tagList.clearSelection();
    }//GEN-LAST:event_clearTagsButtonActionPerformed

    private void clearFormButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearFormButtonActionPerformed
        messageLabel.setText(">");
        tagList.clearSelection();
        SwingUtilities.invokeLater(new ClearDialog());
    }//GEN-LAST:event_clearFormButtonActionPerformed

    void removeAttachment(LsstElogAttachment attach) {
        messageLabel.setText(">");
        attachments.remove(attach);
        entry.removeAttachment(attach.getFileName(), attach.isImage());
        SwingUtilities.invokeLater(new RemoveAttachment(attach));
    }
    
    private String[] extendArray(String[] array) {                                                                                   
        String[] newArray = new String[1 + array.length];                                                                  
        newArray[0] = select;                                                                                            
        System.arraycopy(array, 0, newArray, 1, array.length);                                                             
        return newArray;                                                                                                       
    }

    private class ClearDialog implements Runnable {

        ClearDialog() {
        }

        @Override
        public void run() {
            for (LsstElogAttachment attach : attachments) {
                attachmentsPanel.remove(attach);
            }
            attachmentsPanel.revalidate();
            attachments.clear();
            entryTextArea.setText("");
        }
    }

    private class AddAttachment implements Runnable {

        private LsstElogAttachment attach;

        AddAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            attachmentsPanel.add(attach, 0);
        }
    }

    private class RemoveAttachment implements Runnable {

        private LsstElogAttachment attach;

        RemoveAttachment(LsstElogAttachment attach) {
            this.attach = attach;
        }

        @Override
        public void run() {
            attachmentsPanel.remove(attach);
            attachmentsPanel.revalidate();
            attachmentsPanel.repaint();
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addAttachmentButton;
    private javax.swing.JLabel attachmentsLabel;
    private javax.swing.JPanel attachmentsPanel;
    private javax.swing.JComboBox categoryComboBox;
    private javax.swing.JLabel categoryLabel;
    private javax.swing.JButton clearFormButton;
    private javax.swing.JButton clearTagsButton;
    private javax.swing.JTextArea entryTextArea;
    private javax.swing.JLabel entryTextLabel;
    private javax.swing.Box.Filler filler1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel messageLabel;
    private javax.swing.JButton submitEntryButton;
    private javax.swing.JList tagList;
    private javax.swing.JLabel tagsLabel;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JComboBox versionComboBox;
    private javax.swing.JLabel versionLabel;
    // End of variables declaration//GEN-END:variables
}
