/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.images.ImageHandler;
import org.freehep.graphicsio.test.TestingPanel;

public class TestImage2D
extends TestingPanel {
    static Stroke stroke = new BasicStroke(5.0f, 1, 1);
    private Image image;
    private BufferedImage image1;
    private BufferedImage image2;

    public TestImage2D(String[] args) throws Exception {
        super(args);
        this.setName("Images2D");
        MediaTracker t = new MediaTracker(this);
        this.image = ImageHandler.getImage((String)"images/transparent-image.gif", TestImage2D.class);
        t.addImage(this.image, 0);
        try {
            t.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.image1 = new BufferedImage(this.image.getWidth(this), this.image.getHeight(this), 1);
        this.image1.createGraphics().drawImage(this.image, 0, 0, this);
        this.image2 = new BufferedImage(this.image.getWidth(this), this.image.getHeight(this), 1);
        this.image2.createGraphics().drawImage(this.image, 0, 0, this);
    }

    public void paintComponent(Graphics g) {
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        AffineTransform transform = vg.getTransform();
        vg.setColor(Color.white);
        vg.fillRect(0, 0, this.getWidth(), this.getHeight());
        vg.drawImage((Image)this.image1, new AffineTransform(), (ImageObserver)this);
        vg.shear(0.2, 0.2);
        AffineTransform t = new AffineTransform();
        t.rotate(0.5, -40.0, 0.0);
        t.translate(250.0, -50.0);
        t.shear(-0.3, 0.0);
        vg.drawImage(this.image, t, (ImageObserver)this);
        float[] SHARPEN3x3 = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        Kernel kernel = new Kernel(3, 3, SHARPEN3x3);
        ConvolveOp cop = new ConvolveOp(kernel, 1, null);
        vg.drawImage(this.image2, (BufferedImageOp)cop, 300, -80);
        vg.setTransform(transform);
    }

    public static void main(String[] args) throws Exception {
        new TestImage2D(args).runTest();
    }
}

