/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingCommandResponse;
import org.lsst.ccs.scripting.ScriptingTimeoutException;
import org.lsst.ccs.utilities.tracers.Names;

public class ScriptingSubsystemWrapper {
    private String subsystemName;
    private SynchronousCommandAgent cmdAgent;
    private final MessagingFactory fac;

    protected ScriptingSubsystemWrapper(String subsystemName) {
        this.fac = MessagingFactory.getInstance().forSubsystem(Names.almostUniqueAgentName((String)("scriptingWrapper-" + subsystemName)));
        this.cmdAgent = new SynchronousCommandAgent(this.fac);
        this.subsystemName = subsystemName;
    }

    public ScriptingCommandResponse synchCommand(int timeout, String commandName, Object ... args) throws ScriptingTimeoutException, Exception {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(commandName, args);
        return this.internalSynchCommand(timeout, cmd);
    }

    private ScriptingCommandResponse internalSynchCommand(int timeout, ModuleInvokerCommand cmd) throws ScriptingTimeoutException, Exception {
        try {
            cmd.setDestination(this.subsystemName);
            Object result = this.cmdAgent.invoke((Command)cmd, timeout * 1000);
            return new ScriptingCommandResponse(result);
        }
        catch (TimeoutException ex) {
            ScriptingTimeoutException timeoutException = new ScriptingTimeoutException("timeout", ex);
            if (CCS.getThrowExceptions()) {
                throw timeoutException;
            }
            return new ScriptingCommandResponse(timeoutException);
        }
        catch (Exception e) {
            if (CCS.getThrowExceptions()) {
                throw e;
            }
            return new ScriptingCommandResponse(e);
        }
    }

    public ScriptingCommandResponse synchCommandLine(int timeout, String command) throws ScriptingTimeoutException, Exception {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, null);
        cmd.setUnParsed(true);
        return this.internalSynchCommand(timeout, cmd);
    }

    public Future<Object> asynchCommand(String commandName, Object ... args) throws Exception {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(commandName, args);
        return this.internalAsynchCommand(cmd);
    }

    public Future<Object> internalAsynchCommand(ModuleInvokerCommand cmd) throws Exception {
        cmd.setDestination(this.subsystemName);
        Future f = null;
        try {
            f = this.cmdAgent.invokeFuture((Command)cmd);
        }
        catch (Exception e) {
            final Exception ex = e;
            if (CCS.getThrowExceptions()) {
                throw ex;
            }
            f = new Future(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                public Object get() throws InterruptedException, ExecutionException {
                    return ex;
                }

                public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return ex;
                }
            };
        }
        return f;
    }

    public Future<Object> asynchCommandLine(String command) throws Exception {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, null);
        cmd.setUnParsed(true);
        return this.internalAsynchCommand(cmd);
    }
}

