/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.locking;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.locking.LockUpdateCommand;

public class LockArbitrator
extends Subsystem {
    Map<String, LockOwnerInfo> locks = new HashMap<String, LockOwnerInfo>();
    Map<String, String> busMasterTokens = new HashMap<String, String>();

    public static void main(String[] args) {
        new LockArbitrator();
    }

    public LockArbitrator() {
        this.setName("LockArbitrator");
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public void handleLockRequest(String targetSystem, String token, boolean isAcquire, String origin) {
        if (isAcquire) {
            this.handleLockAcquire(targetSystem, token, origin);
        } else {
            this.handleLockRelease(targetSystem, token, origin);
        }
    }

    void handleLockAcquire(String targetSystem, String token, String origin) {
        log.info((Object)("got lock request " + targetSystem + "/" + token + "/" + origin), new String[0]);
        LockOwnerInfo lockInfo = this.locks.get(targetSystem);
        if (lockInfo != null) {
            throw new RuntimeException("lock on " + targetSystem + " already held by " + lockInfo.ownerSubsystem);
        }
        String sys = targetSystem;
        while (sys.contains("/")) {
            lockInfo = this.locks.get(sys = sys.substring(0, sys.lastIndexOf(47)));
            if (lockInfo == null || lockInfo.token.equals(token)) continue;
            throw new RuntimeException("lock on " + sys + " already held by " + lockInfo.ownerSubsystem);
        }
        for (String locked : this.locks.keySet()) {
            if (!locked.startsWith(targetSystem)) continue;
            lockInfo = this.locks.get(locked);
            if (lockInfo.token.equals(token)) continue;
            throw new RuntimeException("lock on " + locked + " already held by " + lockInfo.ownerSubsystem);
        }
        lockInfo = new LockOwnerInfo(origin, token, targetSystem);
        LockUpdateCommand cmd = new LockUpdateCommand(targetSystem, lockInfo, true);
        MessagingFactory mFac = MessagingFactory.getInstance().forSubsystem("LockArbitrator");
        mFac.sendCommand((Command)cmd);
        this.locks.put(targetSystem, lockInfo);
        sys = targetSystem;
    }

    void handleLockRelease(String targetSystem, String token, String origin) {
        log.info((Object)("got lock release " + targetSystem + "/" + token + "/" + origin), new String[0]);
        LockOwnerInfo lockInfo = this.locks.get(targetSystem);
        if (lockInfo == null || !lockInfo.token.equals(token)) {
            throw new RuntimeException("lock on " + targetSystem + " was not held by " + origin);
        }
        lockInfo = this.locks.remove(targetSystem);
        LockUpdateCommand cmd = new LockUpdateCommand(targetSystem, lockInfo, false);
        MessagingFactory mfac = MessagingFactory.getInstance().forSubsystem("LockArbitrator");
        mfac.sendCommand((Command)cmd);
    }

    public boolean registerBusMaster(String busMasterName, String key) {
        log.info((Object)("new bus master " + busMasterName + "/" + key), new String[0]);
        this.busMasterTokens.put(busMasterName, key);
        return true;
    }

    public static class LockOwnerInfo
    implements Serializable {
        private static final long serialVersionUID = -4617055970681678439L;
        public String ownerSubsystem;
        public String token;
        public String target;

        public LockOwnerInfo(String ownerSubsystem, String token, String target) {
            this.ownerSubsystem = ownerSubsystem;
            this.token = token;
            this.target = target;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("lock(");
            b.append(this.target);
            b.append(" by ");
            b.append(this.ownerSubsystem);
            b.append("/");
            b.append(this.token);
            b.append(')');
            return b.toString();
        }
    }
}

