/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.gdi.Text;

public class TextA
extends Text {
    public TextA(Point pos, String string, int options, Rectangle bounds, int[] widths) {
        super(pos, string, options, bounds, widths);
    }

    public static TextA read(EMFInputStream emf) throws IOException {
        Point pos = emf.readPOINTL();
        int sLen = emf.readDWORD();
        emf.readDWORD();
        int options = emf.readDWORD();
        Rectangle bounds = emf.readRECTL();
        emf.readDWORD();
        String string = new String(emf.readBYTE(sLen));
        if (sLen % 4 != 0) {
            for (int i = 0; i < 4 - sLen % 4; ++i) {
                emf.readBYTE();
            }
        }
        int[] widths = new int[sLen];
        for (int i = 0; i < sLen; ++i) {
            widths[i] = emf.readDWORD();
        }
        return new TextA(pos, string, options, bounds, widths);
    }

    public void write(EMFOutputStream emf) throws IOException {
        int i;
        emf.writePOINTL(this.pos);
        emf.writeDWORD(this.string.length());
        emf.writeDWORD(76);
        emf.writeDWORD(this.options);
        emf.writeRECTL(this.bounds);
        int pad = this.string.length() % 4;
        if (pad > 0) {
            pad = 4 - pad;
        }
        emf.writeDWORD(76 + this.string.length() + pad);
        emf.writeBYTE(this.string.getBytes());
        for (i = 0; i < pad; ++i) {
            emf.writeBYTE(0);
        }
        for (i = 0; i < this.string.length(); ++i) {
            emf.writeDWORD(this.widths[i]);
        }
    }

    public String toString() {
        StringBuffer widthsS = new StringBuffer();
        for (int i = 0; i < this.string.length(); ++i) {
            widthsS.append(",");
            widthsS.append(this.widths[i]);
        }
        widthsS.append(']');
        widthsS.setCharAt(0, '[');
        return "  TextA\n    pos: " + this.pos + "\n    options: " + this.options + "\n    bounds: " + this.bounds + "\n    string: " + this.string + "\n    widths: " + widthsS;
    }
}

