/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelection;

public class TimeSelectionComboBoxModel
extends DefaultComboBoxModel<TimeSelection> {
    public static final String CUSTOM_TIME_SELECTION = "Choose...";
    private final Studio app;

    public TimeSelectionComboBoxModel(Studio application) {
        this.app = application;
        this.addElement(new TimeSelection(CUSTOM_TIME_SELECTION, "", "", false));
        TimeSelection selectedItem = new TimeSelection("Last Hour", "now-3600", "now", false);
        this.addElement(selectedItem);
        this.addElement(new TimeSelection("Last 6 Hours", "now-21600", "now", false));
        this.addElement(new TimeSelection("Last 24 Hours", "now-86400", "now", false));
        TimeSelection[] customRanges = new TimeSelection[]{};
        Arrays.sort(customRanges, new Comparator<TimeSelection>(){

            @Override
            public int compare(TimeSelection o1, TimeSelection o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        TimeSelection[] timeSelectionArray = customRanges;
        int n = customRanges.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSelection ts = timeSelectionArray[n2];
            this.addElement(ts);
            ++n2;
        }
        this.setSelectedItem(selectedItem);
    }

    public void addRange(TimeSelection range) {
        String name = range.name;
        int nElements = this.getSize();
        boolean needSave = range.isPersistent();
        if (nElements > 4) {
            int i = 4;
            while (i < nElements) {
                TimeSelection element = (TimeSelection)this.getElementAt(i);
                int out = name.compareTo(element.name);
                if (out == 0) {
                    if (element == range) break;
                    needSave = needSave || ((TimeSelection)this.getElementAt(i)).isPersistent();
                    this.removeElementAt(i);
                    this.insertElementAt(range, i);
                    break;
                }
                if (out > 0) {
                    this.insertElementAt(range, i);
                    break;
                }
                ++i;
            }
            if (i == nElements) {
                this.addElement(range);
            }
        } else {
            this.addElement(range);
        }
        this.setSelectedItem(range);
        if (needSave) {
            this.save();
        }
    }

    public void deleteRange() {
        TimeSelection range = (TimeSelection)this.getSelectedItem();
        this.removeElement(range);
        if (range.isPersistent()) {
            this.save();
        }
    }

    private void save() {
    }
}

