/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionUtils;

public class TimeSelection {
    public static final String DATE_PATTERN = "MM/dd/yyyy HH:mm:ss";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public String name;
    public String lowerEdgeString;
    public String upperEdgeString;
    private boolean persist;

    public TimeSelection(String name, String lowerEdgeString, String upperEdgeString, boolean persistent) {
        this.name = name;
        this.lowerEdgeString = lowerEdgeString;
        this.upperEdgeString = upperEdgeString;
        this.persist = persistent;
    }

    public long getLowerEdge() {
        return this.getEdge(this.lowerEdgeString);
    }

    public long getUpperEdge() {
        return this.getEdge(this.upperEdgeString);
    }

    private long getEdge(String edgeString) {
        try {
            Date d = DATE_FORMAT.parse(edgeString);
            return d.getTime();
        }
        catch (ParseException parseException) {
            try {
                return (long)(1000.0 * TimeSelectionUtils.getSecondsForString(edgeString));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void setPersistent(boolean persistent) {
        this.persist = persistent;
    }

    public String toString() {
        return this.name;
    }
}

