/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.jms;

import java.util.Properties;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;

class JmsPreferences {
    public static final String JMS_SERVER_PROPERTY = "org.lsst.jms.server";
    private static final String JMS_PORT_PROPERTY = "org.lsst.jms.port";
    private static final String JMS_USE_PROPERTY = "org.lsst.jms.use";
    private String server;
    private int port;
    private final Properties user;
    private boolean useTransport;

    JmsPreferences(Studio studio) {
        this.user = studio.getUserProperties();
        this.server = this.user.getProperty(JMS_SERVER_PROPERTY, "localhost");
        this.port = PropertyUtilities.getInteger((Properties)this.user, (String)JMS_PORT_PROPERTY, (int)3700);
        this.useTransport = PropertyUtilities.getBoolean((Properties)this.user, (String)JMS_USE_PROPERTY, (boolean)false);
        if (this.useTransport && this.canUseTransport()) {
            this.activate();
        }
    }

    int getJmsPort() {
        return this.port;
    }

    String getJmsServer() {
        return this.server;
    }

    public boolean isUseTransport() {
        return this.useTransport;
    }

    void setJmsPort(int port) {
        this.port = port;
        PropertyUtilities.setInteger((Properties)this.user, (String)JMS_PORT_PROPERTY, (int)port);
    }

    public void setJmsServer(String server) {
        this.server = server;
        this.user.setProperty(JMS_SERVER_PROPERTY, server);
    }

    void setUseTransport(boolean selected) {
        this.useTransport = selected;
        PropertyUtilities.setBoolean((Properties)this.user, (String)JMS_USE_PROPERTY, (boolean)selected);
    }

    final boolean canUseTransport() {
        try {
            Class.forName("org.lsst.ccs.bus.jms.JMSMessagingFactory");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    final void activate() {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", this.getJmsServer());
        System.setProperty("org.omg.CORBA.ORBInitialPort", String.valueOf(this.getJmsPort()));
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.jms.JMSMessagingFactory");
    }
}

