/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.freehep.application.studio.PluginDir;
import org.freehep.util.VersionComparator;

public class LibInfo {
    private String id;
    private String version;
    private String location;
    private String href;
    private PluginDir dir;
    private File file;

    public LibInfo(String location, String href) {
        this.href = href;
        int i = location.lastIndexOf(46);
        if (i != -1) {
            location = location.substring(0, i);
        }
        try {
            this.id = VersionComparator.stripVersion((String)location);
            this.version = location.substring(this.id.length() + 1);
        }
        catch (IllegalArgumentException x) {
            this.id = location;
        }
        this.location = this.id;
    }

    public LibInfo(File file, PluginDir dir) {
        block3: {
            this.file = file.getAbsoluteFile();
            this.dir = dir;
            String fileName = file.getName();
            int i = fileName.lastIndexOf(46);
            if (i != -1) {
                fileName = fileName.substring(0, i);
            }
            try {
                this.id = VersionComparator.stripVersion((String)fileName);
                this.version = fileName.substring(this.id.length() + 1);
                this.location = this.id;
            }
            catch (IllegalArgumentException x) {
                this.location = fileName;
                if (this.checkMavenID()) break block3;
                this.id = fileName;
            }
        }
    }

    public LibInfo(LibInfo other) {
        this.id = other.id;
        this.version = other.version;
        this.location = other.location;
        this.href = other.href;
        this.dir = other.dir;
        this.file = other.file;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public PluginDir getDir() {
        return this.dir;
    }

    public void setDir(PluginDir dir) {
        this.dir = dir;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkMavenID() {
        if (this.file == null || !this.file.exists()) {
            return false;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(this.file);
            JarEntry je = jar.getJarEntry("META-INF/maven");
            if (je != null) {
                Enumeration<JarEntry> entries = jar.entries();
                while (true) {
                    if (entries.hasMoreElements()) {
                        je = entries.nextElement();
                        String name = je.getName();
                        if (!name.startsWith("META-INF/maven") || !name.endsWith("pom.properties")) continue;
                        Properties p = new Properties();
                        p.load(jar.getInputStream(je));
                        String mid = p.getProperty("artifactId");
                        String mver = p.getProperty("version");
                        if (mver == null || mid == null) {
                            throw new IllegalArgumentException();
                        }
                        VersionComparator.getVersion((String)mver);
                        this.id = mid;
                        this.version = mver;
                        boolean bl = true;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (IOException x) {
        }
        catch (IllegalArgumentException x) {
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException x) {}
        }
        return false;
    }
}

