/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelection;

public class TimeSelectionPanel
extends JPanel {
    final Pattern _nowPattern = Pattern.compile("\\s*now\\s*-?\\s*(\\d*)\\s*");
    final int MAX_YEARS = 50;
    final int SECONDS_IN_YEAR = 31536000;
    final int SECONDS_IN_DAY = 86400;
    final int SECONDS_IN_HOUR = 3600;
    final int SECONDS_IN_MINUTE = 60;
    private final int VSPACE = 5;
    private final int HSPACE = 10;
    private final TimePanel fromPanel;
    private final TimePanel toPanel;
    private final JTextField nameField;
    private final JCheckBox saveCheck;
    private static TimeSelection range;
    private static JButton okButton;

    public TimeSelectionPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.fromPanel = new TimePanel(" Starting ");
        this.add(this.fromPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.toPanel = new TimePanel(" Ending ");
        this.add(this.toPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        Box saveBox = Box.createVerticalBox();
        saveBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Remember As "), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.nameField = new JTextField();
        this.nameField.setColumns(30);
        this.nameField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                TimeSelectionPanel.this.saveCheck.setEnabled(!TimeSelectionPanel.this.nameField.getText().trim().isEmpty());
            }
        });
        saveBox.add(this.nameField);
        saveBox.add(Box.createRigidArea(new Dimension(0, 5)));
        this.saveCheck = new JCheckBox("Remember between sessions");
        saveBox.add(this.saveCheck);
        this.add(saveBox);
        if (range == null) {
            this.fromPanel.setTime("now - 86400");
            this.toPanel.setTime("now");
            this.saveCheck.setEnabled(false);
        } else {
            this.fromPanel.setTime(TimeSelectionPanel.range.lowerEdgeString);
            this.toPanel.setTime(TimeSelectionPanel.range.upperEdgeString);
            this.nameField.setText(TimeSelectionPanel.range.name);
            this.saveCheck.setSelected(range.isPersistent());
            this.saveCheck.setEnabled(true);
        }
    }

    private void checkValidy() {
        okButton.setEnabled(this.fromPanel.isDataValid() && this.toPanel.isDataValid());
    }

    private TimeSelection getRange() {
        boolean persistent;
        String name = this.nameField.getText().trim();
        boolean bl = persistent = !name.isEmpty() && this.saveCheck.isSelected();
        if (name.isEmpty()) {
            name = "custom";
        }
        String start = this.fromPanel.getTime();
        String end = this.toPanel.getTime();
        if (range == null) {
            range = new TimeSelection(name, start, end, persistent);
        } else {
            TimeSelectionPanel.range.name = name;
            TimeSelectionPanel.range.lowerEdgeString = start;
            TimeSelectionPanel.range.upperEdgeString = end;
            range.setPersistent(persistent);
        }
        return range;
    }

    public static TimeSelection getTimeSelection(JComponent parent, TimeSelection seed) {
        range = seed;
        okButton = new JButton("  OK  ");
        TimeSelectionPanel tsp = new TimeSelectionPanel();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeSelectionPanel.this.getRange();
                Window w = SwingUtilities.getWindowAncestor(TimeSelectionPanel.this);
                if (w != null) {
                    w.setVisible(false);
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                range = null;
                Window w = SwingUtilities.getWindowAncestor(TimeSelectionPanel.this);
                if (w != null) {
                    w.setVisible(false);
                }
            }
        });
        JOptionPane.showOptionDialog(parent, tsp, "Select time range", 2, -1, null, new Object[]{okButton, cancelButton}, null);
        okButton = null;
        return range;
    }

    public static void main(String ... arg) {
        System.out.println("Entered: " + TimeSelectionPanel.getTimeSelection(null, null));
    }

    private class TimePanel
    extends JPanel {
        final JTextField _field;
        final ButtonGroup _group;
        final JRadioButton _absButton;
        final JRadioButton _relButton;
        final JSpinner _timeSpinner;
        final JSpinner _yearSpinner;
        final JSpinner _daySpinner;
        final JSpinner _hourSpinner;
        final JSpinner _minSpinner;
        final JSpinner _secSpinner;
        final SpinnerDateModel _timeSpinnerModel;
        final SpinnerNumberModel _yearSpinnerModel;
        final SpinnerNumberModel _daySpinnerModel;
        final SpinnerNumberModel _hourSpinnerModel;
        final SpinnerNumberModel _minSpinnerModel;
        final SpinnerNumberModel _secSpinnerModel;
        boolean _listen = false;
        ChangeListener _absListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TimePanel.this._listen) {
                    TimePanel.this._listen = false;
                    TimePanel.this.updateFromAbsolute();
                    TimePanel.this._listen = true;
                }
            }
        };
        ChangeListener _relListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TimePanel.this._listen) {
                    TimePanel.this._listen = false;
                    TimePanel.this.updateFromRelative();
                    TimePanel.this._listen = true;
                }
            }
        };

        TimePanel(String title) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
            this._field = new JTextField();
            this._field.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (TimePanel.this._listen) {
                        TimePanel.this._listen = false;
                        TimePanel.this.updateFromField();
                        TimePanel.this._listen = true;
                    }
                }
            });
            this.add(this._field);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            Box box = Box.createHorizontalBox();
            this.add(box);
            this._group = new ButtonGroup();
            this._absButton = new JRadioButton("Fixed: ");
            this._absButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TimePanel.this._listen) {
                        TimePanel.this._listen = false;
                        TimePanel.this.enableRelative(false);
                        TimePanel.this.updateFromAbsolute();
                        TimePanel.this._field.setForeground(Color.BLACK);
                        TimePanel.this._listen = true;
                    }
                }
            });
            this._group.add(this._absButton);
            box.add(this._absButton);
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            this._timeSpinnerModel = new SpinnerDateModel(new Date(), null, null, 10);
            this._timeSpinner = new JSpinner(this._timeSpinnerModel);
            this._timeSpinner.setEditor(new JSpinner.DateEditor(this._timeSpinner, " MM/dd/yyyy HH:mm:ss "));
            this._timeSpinner.addChangeListener(this._absListener);
            box.add(this._timeSpinner);
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            box.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            box = Box.createHorizontalBox();
            this.add(box);
            this._relButton = new JRadioButton();
            this._relButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TimePanel.this._listen) {
                        TimePanel.this._listen = false;
                        TimePanel.this.enableRelative(true);
                        TimePanel.this.updateFromRelative();
                        TimePanel.this._field.setForeground(Color.BLACK);
                        TimePanel.this._listen = true;
                    }
                }
            });
            this._group.add(this._relButton);
            box.add(this._relButton);
            this._yearSpinnerModel = new SpinnerNumberModel(0, 0, 50, 1);
            this._yearSpinner = new JSpinner(this._yearSpinnerModel);
            this._yearSpinner.addChangeListener(this._relListener);
            box.add(this._yearSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("years"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._daySpinnerModel = new SpinnerNumberModel(0, 0, 999, 1);
            this._daySpinner = new JSpinner(this._daySpinnerModel);
            this._daySpinner.addChangeListener(this._relListener);
            box.add(this._daySpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("days"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._hourSpinnerModel = new SpinnerNumberModel(0, 0, 99, 1);
            this._hourSpinner = new JSpinner(this._hourSpinnerModel);
            this._hourSpinner.addChangeListener(this._relListener);
            box.add(this._hourSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("hours"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._minSpinnerModel = new SpinnerNumberModel(0, 0, 99, 1);
            this._minSpinner = new JSpinner(this._minSpinnerModel);
            this._minSpinner.addChangeListener(this._relListener);
            box.add(this._minSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("minutes"));
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            this._secSpinnerModel = new SpinnerNumberModel(0, 0, 9999, 1);
            this._secSpinner = new JSpinner(this._secSpinnerModel);
            this._secSpinner.addChangeListener(this._relListener);
            box.add(this._secSpinner);
            box.add(Box.createRigidArea(new Dimension(5, 0)));
            box.add(new JLabel("seconds  in the past"));
            box.add(Box.createRigidArea(new Dimension(10, 0)));
            box.add(Box.createHorizontalGlue());
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this._listen = true;
        }

        boolean isDataValid() {
            return this._field.getForeground() == Color.BLACK;
        }

        String getTime() {
            if (this._absButton.isSelected()) {
                this.updateFromAbsolute();
            } else {
                this.updateFromRelative();
            }
            return this._field.getText().trim();
        }

        void setTime(String time) {
            this._field.setText(time);
            this.updateFromField();
        }

        private void setValid(boolean isValid) {
            if (isValid) {
                this._field.setForeground(Color.BLACK);
            } else {
                this._field.setForeground(Color.RED);
            }
            TimeSelectionPanel.this.checkValidy();
        }

        private void updateFromAbsolute() {
            this._field.setText(TimeSelection.DATE_FORMAT.format(this._timeSpinnerModel.getDate()));
        }

        private void updateFromRelative() {
            int seconds = 31536000 * this._yearSpinnerModel.getNumber().intValue() + 86400 * this._daySpinnerModel.getNumber().intValue() + 3600 * this._hourSpinnerModel.getNumber().intValue() + 60 * this._minSpinnerModel.getNumber().intValue() + this._secSpinnerModel.getNumber().intValue();
            this._field.setText("now" + (seconds > 0 ? " - " + seconds : ""));
        }

        private void updateFromField() {
            String data = this._field.getText();
            Matcher m = TimeSelectionPanel.this._nowPattern.matcher(data);
            long seconds = -1L;
            if (m.matches()) {
                try {
                    String ddd = m.group(1);
                    long l = seconds = ddd.isEmpty() ? 0L : Long.parseLong(ddd);
                    if (seconds / 31536000L > 50L) {
                        seconds = -1L;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (seconds < 0L) {
                    this.setValid(false);
                } else {
                    this.setValid(true);
                    this._yearSpinnerModel.setValue(seconds / 31536000L);
                    this._daySpinnerModel.setValue((seconds %= 31536000L) / 86400L);
                    this._hourSpinnerModel.setValue((seconds %= 86400L) / 3600L);
                    this._minSpinnerModel.setValue((seconds %= 3600L) / 60L);
                    this._secSpinnerModel.setValue(seconds %= 60L);
                    this.enableRelative(true);
                }
            } else {
                try {
                    Date date = TimeSelection.DATE_FORMAT.parse(data);
                    this._timeSpinnerModel.setValue(date);
                    this.enableRelative(false);
                    this.setValid(true);
                }
                catch (ParseException parseException) {
                    this.setValid(false);
                }
            }
        }

        private void enableRelative(boolean relative) {
            this._timeSpinner.setEnabled(!relative);
            this._yearSpinner.setEnabled(relative);
            this._daySpinner.setEnabled(relative);
            this._hourSpinner.setEnabled(relative);
            this._minSpinner.setEnabled(relative);
            this._secSpinner.setEnabled(relative);
            if (relative) {
                this._relButton.setSelected(true);
            } else {
                this._absButton.setSelected(true);
            }
        }
    }
}

