package org.lsst.ccs.plugin.jas3.tutorial;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.freehep.application.studio.Studio;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;

/**
 * A command processor makes it easy to have methods called when user selects
 * menu or toolbar items. It also provides facilities for enabling/disabling
 * menu or toolbar items, and handling checkboxes or toggle buttons.
 *
 * @author tonyj
 */
public class TutorialCommands extends CommandProcessor {

    private Studio studio;
    private TutorialConsole tutorialConsole;
    private boolean chooseMeEnabled = true;
    
    public TutorialCommands(Studio studio) {
        this.studio = studio;
        this.tutorialConsole = new TutorialConsole(studio);
    }

    /*
     * Methods of the form onXXX will be called when the XXX command is activated, 
     * typically by selecting a menu item defined in a ".menus" file with command="XXX".
     */
    public void onChooseMe() {
        JOptionPane.showMessageDialog(studio, "Choose Me was activated");
    }
    /*
     * onXXX commands can be optionally paired with enableXXX methods which can 
     * be used to enable or disable the XXX command.
     */
    public void enableChooseMe(CommandState state) {
        state.setEnabled(chooseMeEnabled);
    }
    /*
     * An example illustrating how a checkbox can be used in a toolbar or menu.
     * In this case the button is used to control the enabled/disabled state of
     * the ChooseMe button.
     */
    public void onEnableChooseMe(boolean onOff) {
        chooseMeEnabled = onOff;
        // Whenever the enabled/disabled state of an item is changed, setChanged()
        // must be called to update the menus.
        setChanged();
    }
    /*
     * In the case of a checkbox or toggle button, the enable method is used both
     * to enable/disable the corresponding menu item, and to set the state of its
     * toggle.
     */
    public void enableEnableChooseMe(BooleanCommandState state) {
        // Not really necessary since this is the default anyway
        state.setEnabled(true);
        state.setSelected(chooseMeEnabled);
    }

    public void onOpenTutorialPage() {
        ImageIcon icon = new ImageIcon(getClass().getResource("Letter T.png"));
        studio.getPageManager().openPage(new TutorialPage(), "Tutorial", icon);
    }

    public void onOpenAdvancedTutorialPage() {
        
        ImageIcon icon = new ImageIcon(getClass().getResource("Letter A.png"));
        studio.getPageManager().openPage(new AdvancedTutorialPage(), "Advanced", icon);
    }
    
    public void onCreateDemoOutputConsole() throws IOException {
        tutorialConsole.createOutputConsole();
    }

    public void onCreateDemoInputConsole() throws IOException {
        tutorialConsole.createInputConsole();
    }

    public void onCreateDemoInputOutputConsole() throws IOException {
        tutorialConsole.createInputOutputConsole();
    }
}
