package org.lsst.ccs.plugin.jas3.trending.timeselection;

import javax.swing.JComponent;
import org.freehep.jas.services.PreferencesTopic;

/**
 * Allows the user to select what time period trending plots should be displayed over.
 * @author turri
 */
public class TimeSelectionPreferencesTopic implements PreferencesTopic {

    private final String[] timeSelectionPreferencesPath = {"LSST","Trending", "Time Selection"};

    public TimeSelectionPreferencesTopic() {
    }
    
    @Override
    public boolean apply(JComponent panel) {
        TimeSelectionPreferencesPanel prefs = (TimeSelectionPreferencesPanel) panel;
        prefs.apply();
        return true;
    }

    @Override
    public String[] path() {
        return timeSelectionPreferencesPath;
    }

    @Override
    public JComponent component() {
        return new TimeSelectionPreferencesPanel();
    }
}
