package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.freehep.application.studio.Studio;

/**
 * A ComboBoxModel to allow selection of different time ranges.
 * @author turri
 */
public class TimeSelectionComboBoxModel extends DefaultComboBoxModel<TimeSelection> {
    
    static public final String CUSTOM_TIME_SELECTION = "Choose...";
    
    final private Studio app;
    
    public TimeSelectionComboBoxModel(Studio application) {
        
        app = application;
        
        addElement(new TimeSelection(CUSTOM_TIME_SELECTION, "", "", false));
        
        // Add standard ranges:
        
        TimeSelection selectedItem = new TimeSelection("Last Hour", "now-3600", "now", false);
        addElement(selectedItem);
        addElement(new TimeSelection("Last 6 Hours", "now-21600", "now", false));
        addElement(new TimeSelection("Last 24 Hours", "now-86400", "now", false));
        
        // Restore custom ranges from application properties:
        
        //System.out.println("Restoring custom ranges");
        TimeSelection[] customRanges = new TimeSelection[0];
        
            Arrays.sort(customRanges, new Comparator<TimeSelection>() {
                public int compare(TimeSelection o1, TimeSelection o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            for (TimeSelection ts : customRanges) {
                addElement(ts);
            }
        
        // Set default selection
        
        setSelectedItem(selectedItem);
    }
    
    /** Adds custom range to this model, removing identically named range if necessary. */
    public void addRange(TimeSelection range) {
        
        String name = range.name;
        int nElements = getSize();
        boolean needSave = range.isPersistent();
        
        if (nElements > 4) {
            
            int i=4;
            for (; i<nElements; i++) {
                TimeSelection element = getElementAt(i);
                int out = name.compareTo(element.name);
                if (out == 0) {
                    if (element != range) {
                        needSave = needSave || getElementAt(i).isPersistent();
                        removeElementAt(i);
                        insertElementAt(range, i);
                    }
                    break;
                } else if (out > 0) {
                    insertElementAt(range, i);
                    break;
                }
            }
            if (i == nElements) {
                addElement(range);
            }
            
        } else {
            
            addElement(range);
            
        }
        
        setSelectedItem(range);
        if (needSave) save();
    }
    
    public void deleteRange() {
        TimeSelection range = (TimeSelection) getSelectedItem();
        removeElement(range);
        if (range.isPersistent()) save();
    }
    
    /** Saves persistent time ranges to application properties. */
    private void save() {
        //System.out.println("Saving custom ranges");
    }
    
}
