package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.freehep.application.studio.Studio;

/**
 *
 * @author onoprien
 */
public class TimeSelectionComboBox extends JComboBox {
    
    ActionListener selectionListener = new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            //System.out.println("action listener in TimeSelectionComboBox");
            TimeSelection ts = (TimeSelection) getModel().getSelectedItem();
            if (ts.name.equals(TimeSelectionComboBoxModel.CUSTOM_TIME_SELECTION)) {
                ts = TimeSelectionPanel.getTimeSelection(TimeSelectionComboBox.this, null);
                if (ts == null) {
                    setSelectedIndex(1);
                } else {
                    getModel().addRange(ts);
                }
            }
        }
    };
    
    public TimeSelectionComboBox(Studio application) {
        super(new TimeSelectionComboBoxModel(application));
        setRenderer(new Renderer(getRenderer()));
        addActionListener(selectionListener);
    }
    
    
    @Override
    public TimeSelectionComboBoxModel getModel() {
        return (TimeSelectionComboBoxModel) super.dataModel;
    }
    
    
    private class Renderer implements ListCellRenderer {

        private final ListCellRenderer horse;
        private final JPanel separatorPanel = new JPanel(new BorderLayout());
        private final JSeparator separator = new JSeparator();

        Renderer(ListCellRenderer renderer) {
            horse = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = horse.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (index == 0 || index == 3) {
                separatorPanel.removeAll();
                separatorPanel.add(comp, BorderLayout.CENTER);
                separatorPanel.add(separator, BorderLayout.SOUTH);
                comp = separatorPanel;
            }
            return comp;
        }

    }
    
}
