package org.lsst.ccs.plugin.jas3.trending.timeselection;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author turri
 */
public class TimeSelection {
    
    static final public String DATE_PATTERN = "MM/dd/yyyy HH:mm:ss";
    static final public SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(DATE_PATTERN);
    
    public String name, lowerEdgeString, upperEdgeString;
    private boolean persist;
    
    public TimeSelection(String name, String lowerEdgeString, String upperEdgeString, boolean persistent) {
        this.name = name;
        this.lowerEdgeString = lowerEdgeString;
        this.upperEdgeString = upperEdgeString;
        persist = persistent;
    }
    
    public long getLowerEdge() {
        return getEdge(lowerEdgeString);
    }
    
    public long getUpperEdge() {
        return getEdge(upperEdgeString);
    }
    
    private long getEdge(String edgeString) {
        try {
            Date d = DATE_FORMAT.parse(edgeString);
            return d.getTime();
        } catch (ParseException x) {
        }
        try {
            return (long)(1000*TimeSelectionUtils.getSecondsForString(edgeString));        
        } catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
    
    public boolean isPersistent() {
        return persist;
    }
    
    public void setPersistent(boolean persistent) {
        persist = persistent;
    }

    @Override
    public String toString() {
        return name;
    }
    
    
    
    
}
