package org.lsst.ccs.plugin.jas3.trending;

import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.util.FreeHEPLookup;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.plugin.jas3.rest.LsstRestPlugin;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionComboBox;
import org.lsst.ccs.plugin.jas3.trending.timeselection.TimeSelectionComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

/**
 * This plugin is responsible for listening for added or removed WebResources
 * registered by the Rest plugin. On detecting changes it will add them to the
 * JAS Tree in the control area.
 *
 * @author tonyj
 */
public class LsstTrendingPlugin extends Plugin {

    private static final Logger logger = Logger.getLogger(LsstRestPlugin.class.getName());
    private Studio studio;
    private TimeSelectionComboBoxModel selectedTimeRange;

    @Override
    protected void init() throws SAXException, IOException {
        logger.finest("LsstTrendingPlugin created");
        studio = getApplication();
        final FreeHEPLookup lookup = studio.getLookup();
        addDataServerListener(lookup);
        selectedTimeRange = addTrendingToolbar();
        // FIXME: Does not work yet
        //lookup.add(new TimeSelectionPreferencesTopic());
        final TrendingService trendingService = new TrendingService() {
            @Override
            public void show(String[] path) {
                FTreeProvider treeProvider = (FTreeProvider) lookup.lookup(FTreeProvider.class);
                if (treeProvider != null) {
                    final FTree tree = treeProvider.tree();
                    FTreeNode node = tree.findNode(new FTreePath(path));
                    tree.adapterForClass(DataChannel.class).doubleClick(node);
                }
            }
        };

        lookup.add(trendingService);
    }

    /**
     * Listens for dataserver restful interfaces to be registered/unregistered.
     * Calls handleWebResource when a change occurs.
     */
    private void addDataServerListener(FreeHEPLookup lookup) {

        Lookup.Template template = new Lookup.Template(WebResource.class, "dataserver", null);
        final Lookup.Result result = lookup.lookup(template);
        handleWebResource(result.allInstances());
        LookupListener ll = new LookupListener() {
            @Override
            public void resultChanged(LookupEvent le) {
                handleWebResource(result.allInstances());
            }
        };
        result.addLookupListener(ll);
    }

    /**
     * Adds a toolbar for selection of time period for new trending plots
     *
     * @throws SAXException
     * @throws IOException
     */
    private TimeSelectionComboBoxModel addTrendingToolbar() throws SAXException, IOException {
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = getClass().getResource("Trending.menus");
        builder.build(xml);

        JToolBar toolbar = builder.getToolBar("trending");
        TimeSelectionComboBox box = new TimeSelectionComboBox(studio);
        box.setEnabled(box.getItemCount() > 0);

        JLabel boxLabel = new JLabel("Trending Period: ");
        toolbar.add(boxLabel, 0);
        toolbar.add(box, 1);
        studio.addToolBar(toolbar, toolbar.getName());
        return box.getModel();
    }

    private void handleWebResource(Collection<WebResource> allInstances) {
        for (WebResource service : allInstances) {
            handleDataServer(service);
            return;
        }
        handleDataServer(null);
    }

    private void handleDataServer(WebResource service) {
        FreeHEPLookup lookup = studio.getLookup();
        FTreeProvider treeProvider = (FTreeProvider) lookup.lookup(FTreeProvider.class);
        if (treeProvider != null) {
            final FTree tree = treeProvider.tree();

            if (service == null) {
                logger.log(Level.INFO, "WebResource removed");
                FTreeNode root = tree.root();
                // Clear old tree data
                for (FTreeNode node : (Collection<FTreeNode>) (root.childNodes())) {
                    tree.treeChanged(new FTreeNodeRemovedNotification(studio, node.path()));
                }
            } else {
                logger.log(Level.INFO, "WebResource registered {0}", service);

                DataChannel.DataChannelList channelList = (DataChannel.DataChannelList) lookup.lookup(DataChannel.DataChannelList.class);

                treeProvider.treeNodeAdapterRegistry().registerNodeAdapter(new DataChannelTreeAdapter(service, selectedTimeRange), DataChannel.class);
                for (DataChannel chan : channelList.list) {
                    tree.treeChanged(new FTreeNodeAddedNotification(studio, chan.getPathAsString(), chan));
                }
            }
        }
    }
}
