/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.plot.PrintHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.graphicsbase.util.export.ExportDialog;
import org.freehep.graphicsbase.util.export.ExportFileType;
import org.freehep.graphicsbase.util.export.VectorGraphicsTransferable;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.plotter.PlotMLExportFileType;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.FreeHEPLookup;

public class JAS3Plot
extends JASHist
implements HasPopupItems,
ActionListener {
    private ArrayList dataList = new ArrayList();

    protected JAS3Plot() {
        this.setShowStatistics(true);
        this.setBackground(Color.white);
        this.setAllowPopupMenus(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container page;
                Container region = JAS3Plot.this.getParent();
                if (region instanceof PlotRegion && (page = region.getParent()) instanceof PlotPage) {
                    ((PlotPage)((Object)page)).setCurrentRegion((PlotRegion)((Object)region));
                }
            }
        });
    }

    protected List data() {
        return this.dataList;
    }

    public void addJAS3Data(JAS3DataSource ds) {
        if (this.dataList.contains(ds)) {
            return;
        }
        this.dataList.add(ds);
    }

    public void removeJAS3Data(DataSource ds) {
        for (int i = 0; i < this.dataList.size(); ++i) {
            if (((JAS3DataSource)this.dataList.get(i)).dataSource() != ds) continue;
            this.dataList.remove(i);
            break;
        }
    }

    public JASHistData addData(DataSource ds) {
        JASHistData jasHistData = super.addData(ds);
        this.setTitleAndAxisLabels(this);
        return jasHistData;
    }

    public void removeAllData() {
        super.removeAllData();
        this.clearDataList();
    }

    void clearDataList() {
        for (int i = 0; i < this.dataList.size(); ++i) {
            ((JAS3DataSource)this.dataList.get(i)).destroy();
        }
        this.dataList.clear();
    }

    public void destroy() {
        Container c = this.getParent();
        if (c != null) {
            c.remove((Component)((Object)this));
            c.repaint();
        }
        super.destroy();
        this.clearDataList();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command.equals("save")) {
            Application studio = Application.getApplication();
            Properties user = studio.getUserProperties();
            String creator = user.getProperty("fullVersion");
            ExportDialog dlg = new ExportDialog(creator, true);
            dlg.addExportFileType((ExportFileType)new PlotMLExportFileType());
            dlg.setUserProperties(user);
            PrintHelper.instance().setPrintingThread(Thread.currentThread());
            dlg.showExportDialog((Component)studio, "Save As...", (Component)((Object)this), "plot");
            PrintHelper.instance().setPrintingThread(null);
        } else if (command.equals("copy")) {
            Clipboard cb = this.getToolkit().getSystemClipboard();
            VectorGraphicsTransferable t = new VectorGraphicsTransferable((Component)((Object)this));
            cb.setContents((Transferable)t, (ClipboardOwner)t);
        } else if (command.equals("print")) {
            Studio studio = (Studio)Application.getApplication();
            try {
                org.freehep.application.PrintHelper ph = new org.freehep.application.PrintHelper((Component)((Object)this), studio);
                PrintHelper.instance().setPrintingThread(Thread.currentThread());
                ph.print();
                PrintHelper.instance().setPrintingThread(null);
            }
            catch (PrinterException x) {
                studio.error("Error printing plot", x);
            }
        }
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        int i;
        for (Component c = source; c != null; c = c.getParent()) {
            if (!(c instanceof jas.plot.HasPopupItems)) continue;
            ((jas.plot.HasPopupItems)c).modifyPopupMenu(menu, source);
        }
        int data = this.dataList.size();
        for (i = 0; i < data; ++i) {
            ((JAS3DataSource)this.dataList.get(i)).modifyPopupMenu(menu, source);
        }
        for (i = 0; i < menu.getComponentCount(); ++i) {
            Component item = menu.getComponent(i);
            if (!(item instanceof JMenuItem)) continue;
            JMenuItem mItem = (JMenuItem)item;
            String name = mItem.getText();
            if (name.indexOf("Advanced") >= 0) {
                menu.remove(i--);
                continue;
            }
            if (name.equals("Save Plot As...")) {
                menu.remove(i--);
                continue;
            }
            if (name.equals("Print")) {
                menu.remove(i--);
                continue;
            }
            if (!name.equals("Copy Plot to Clipboard...")) continue;
            menu.remove(i--);
        }
        this.addPlotMenu(menu, p);
        menu.addSeparator();
        JMenuItem item = new JMenuItem("Copy Plot...");
        item.setActionCommand("copy");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Save Plot As...");
        item.setActionCommand("save");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Print");
        item.setActionCommand("print");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    private void addPlotMenu(JPopupMenu menu, Point p) {
        try {
            Plotter plot = ((PlotFactory)FreeHEPLookup.instance().lookup(PlotFactory.class)).currentPage().currentRegion().currentPlot();
            if (plot instanceof HasPopupItems) {
                ((HasPopupItems)plot).modifyPopupMenu(menu, (Component)((Object)this), p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTitle() {
        this.setTitleAndAxisLabels(this);
        return super.getTitle();
    }

    public String getSuperTitle() {
        return super.getTitle();
    }

    private JAS3DataSource jas3DataSource(DataSource ds, ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            if (((JAS3DataSource)list.get(i)).dataSource() != ds) continue;
            return (JAS3DataSource)list.get(i);
        }
        return new J3Ds(ds);
    }

    private void setTitleAndAxisLabels(JAS3Plot plot) {
        this.setTitle("");
        ArrayList data = new ArrayList();
        Enumeration en = plot.get1DFunctions();
        if (en != null) {
            while (en.hasMoreElements()) {
                data.add(en.nextElement());
            }
        }
        Enumeration en1 = plot.getDataSources();
        while (en1.hasMoreElements()) {
            data.add(en1.nextElement());
        }
        ArrayList tmpDataList = (ArrayList)((ArrayList)plot.data()).clone();
        this.getYAxis().setLabel("");
        this.getXAxis().setLabel("");
        int size = plot.data().size();
        FTreePath[] paths = new FTreePath[size];
        String[] xLabels = new String[size];
        String[] yLabels = new String[size];
        this.dataList = new ArrayList();
        for (int i = 0; i < size; ++i) {
            JAS3DataSource ds = this.jas3DataSource(((JASHistData)data.get(i)).getDataSource(), tmpDataList);
            plot.data().add(ds);
            paths[i] = ds.path();
            String[] axisLabels = ds.axisLabels();
            if (axisLabels == null) continue;
            xLabels[i] = axisLabels[0];
            if (axisLabels.length <= 1) continue;
            yLabels[i] = axisLabels[1];
        }
        if (size == 1) {
            DataSource ds = ((JAS3DataSource)plot.data().get(0)).dataSource();
            this.setTitle(ds.getTitle());
            if (xLabels[0] != null) {
                this.getXAxis().setLabel(xLabels[0]);
            }
            if (yLabels[0] != null) {
                this.getYAxis().setLabel(yLabels[0]);
            }
        } else if (size > 1) {
            int length = paths[0].getPathCount();
            for (int i = 1; i < size; ++i) {
                if (length == paths[i].getPathCount()) continue;
                length = -1;
            }
            if (length > 0) {
                int k;
                String[] commonString = new String[length];
                int commonItems = length;
                block4: for (int j = 0; j < length; ++j) {
                    commonString[j] = paths[0].getPathComponent(j);
                    for (k = 1; k < size; ++k) {
                        if (paths[k].getPathComponent(j).equals(commonString[j])) continue;
                        commonString[j] = null;
                        --commonItems;
                        continue block4;
                    }
                }
                if (commonItems > 0) {
                    String title = null;
                    for (int i = 0; i < length; ++i) {
                        if (commonString[i] == null) continue;
                        title = title == null ? commonString[i] : title + " - " + commonString[i];
                    }
                    this.setTitle(title);
                    for (k = 0; k < data.size(); ++k) {
                        JASHistData d = (JASHistData)data.get(k);
                        StringBuffer legend = new StringBuffer();
                        for (int i = 0; i < length; ++i) {
                            if (commonString[i] != null) continue;
                            if (legend.length() > 0) {
                                legend.append(" - ");
                            }
                            legend.append(paths[k].getPathComponent(i));
                        }
                        d.setLegendText(legend.toString());
                    }
                    return;
                }
            }
            String title = paths[0].getLastPathComponent();
            for (int i = 1; i < size; ++i) {
                title = title + " - " + paths[i].getLastPathComponent();
            }
            this.setTitle(title);
        }
        this.getStats().repaint();
    }

    private class J3Ds
    implements JAS3DataSource {
        private DataSource ds;

        J3Ds(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public String[] axisLabels() {
            return null;
        }

        @Override
        public DataSource dataSource() {
            return this.ds;
        }

        @Override
        public void destroy() {
        }

        @Override
        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        }

        @Override
        public FTreePath path() {
            return new FTreePath(this.ds.getTitle());
        }

        @Override
        public void setAxisType(int type) {
        }
    }
}

