/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import org.lsst.ccs.utilities.logging.ContextLogManager;

public class StackTraceFormats {
    private static int depth = -1;
    private static volatile boolean modified = false;

    public static int getDepth() {
        return depth;
    }

    public static void setDepth(int depth) {
        StackTraceFormats.depth = depth;
        modified = true;
    }

    public static void setDepthFromInitialProperties() {
        if (modified) {
            return;
        }
        int depth = ContextLogManager.loaderGetIntProperty("StackTraceFormats.depth", -1);
        StackTraceFormats.setDepth(depth);
    }

    public static String toString(Throwable throwable, int level) {
        StringBuilder stb = new StringBuilder(String.valueOf(throwable)).append('\n');
        StackTraceElement[] traces = throwable.getStackTrace();
        int size = traces.length;
        if (depth < 0 || size <= depth * 2) {
            StackTraceElement[] stackTraceElementArray = traces;
            int n = traces.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement trace = stackTraceElementArray[n2];
                StackTraceFormats.indent(stb, level).append(trace).append('\n');
                ++n2;
            }
        } else {
            int ix = 0;
            while (ix < depth) {
                StackTraceFormats.indent(stb, level).append(traces[ix]).append('\n');
                ++ix;
            }
            StackTraceFormats.indent(stb, level).append(".....\n");
            ix = size - depth;
            while (ix < size) {
                StackTraceFormats.indent(stb, level).append(traces[ix]).append('\n');
                ++ix;
            }
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            StackTraceFormats.indent(stb, level - 1).append("caused by : ").append(StackTraceFormats.toString(cause, level + 1));
        }
        return stb.toString();
    }

    private static StringBuilder indent(StringBuilder stb, int level) {
        int ix = 0;
        while (ix <= level) {
            stb.append("  ");
            ++ix;
        }
        return stb;
    }
}

