/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.config.BootCommand;
import org.lsst.ccs.config.BootStatus;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.TextAndNode;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.SubsystemBootFromStream;
import org.lsst.gruth.jutils.ComponentNode;

public class SubsystemBootFromBus {
    static volatile boolean commandReceived;
    static Exception thrown;
    static final long TIMEOUT = 1000L;

    public static void main(String[] args) throws Exception {
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        String requestedSubsystem = "";
        String requestedConfiguration = "";
        String requestedTag = "";
        switch (args.length) {
            case 3: {
                requestedTag = args[2];
            }
            case 2: {
                requestedConfiguration = args[1];
            }
            case 1: {
                requestedSubsystem = args[0];
            }
        }
        String macAddress = Subsystem.getEthHardAddress();
        MessagingFactory mfact = MessagingFactory.getInstance().forSubsystem(macAddress);
        mfact.addCommandListener(new CommandListener(){

            public void onCommand(Command m) {
                if (m instanceof BootCommand) {
                    String userName = "";
                    int level = 10;
                    commandReceived = true;
                    BootCommand bcmd = (BootCommand)m;
                    String subsystemName = bcmd.getSubsystemName();
                    String configName = bcmd.getConfigName();
                    String tag = bcmd.getTag();
                    ConfigProfile configProfile = null;
                    SubsystemDescription description = null;
                    if (configName != null && !"".equals(configName)) {
                        configProfile = (ConfigProfile)bcmd.getConfigurationData();
                        description = configProfile.getSubsystemDescription();
                    } else {
                        description = (SubsystemDescription)bcmd.getConfigurationData();
                        configProfile = Factories.createConfigProfile((SubsystemDescription)description, (String)configName, (String)tag, (String)userName, (int)level);
                    }
                    DataFlavour dataFlavour = description.getDataFlavour();
                    ComponentNode componentNode = null;
                    switch (dataFlavour) {
                        case TREE_FROM_SOURCE: {
                            componentNode = ((TextAndNode)description.getConfigurationData()).getComponentNode();
                            break;
                        }
                        case PURE_OBJECT_TREE: {
                            componentNode = (ComponentNode)description.getConfigurationData();
                        }
                    }
                    if (componentNode != null) {
                        try {
                            Subsystem subsystem = BootUtils.rawSubsystemFromDescriptionNode(componentNode, null, subsystemName, configName, tag);
                            LocalConfigurationProxy configurationAccess = new LocalConfigurationProxy(configProfile);
                            subsystem.setConfigurationProxy((ConfigurationProxy)configurationAccess);
                            BootUtils.saveInCache(componentNode, subsystemName, configName, tag);
                            subsystem.start();
                        }
                        catch (Exception exc) {
                            thrown = exc;
                        }
                    }
                }
            }

            public void onReply(CommandReply r) {
            }

            public void onAck(CommandAck a) {
            }
        });
        BootStatus bootStatus = new BootStatus(requestedSubsystem, requestedConfiguration, requestedTag);
        bootStatus.setOrigin(macAddress);
        boolean inTestContext = Boolean.getBoolean("org.lsst.ccs.testcontext");
        bootStatus.setInTestContext(inTestContext);
        mfact.sendStatus((Status)bootStatus);
        Thread.sleep(1000L);
        if (commandReceived) {
            if (thrown != null) {
                throw thrown;
            }
        } else if ("".equals(requestedSubsystem) && "".equals(requestedConfiguration)) {
            BootUtils.bootFromCache();
        } else {
            NamesAndTag namesAndTag = new NamesAndTag(requestedSubsystem, requestedConfiguration, requestedTag);
            SubsystemBootFromStream.main(new String[]{String.valueOf(namesAndTag.toString()) + ".ser"});
        }
    }
}

