/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.ArrayList;
import java.util.Iterator;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.LocalCommandDictionary;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.BasicModularSubSystem;
import org.lsst.ccs.framework.ComponentLookupService;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurationProxy;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.NodeCommand;
import org.lsst.ccs.framework.NodeTreeWalker;
import org.lsst.ccs.framework.NodesFunction;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.startup.NodeLookup;
import org.lsst.gruth.jutils.ComponentNode;

public class NodeModularSubsystem
extends BasicModularSubSystem {
    private ComponentLookupService lookup;

    public NodeModularSubsystem(String name, ConfigurationProxy proxy) {
        super(name);
        this.configurationProxy = proxy;
    }

    protected Configurable getCommandDestination(String commandDestination) {
        Configurable configurable = null;
        String configurableName = "main";
        if (commandDestination.contains("/")) {
            configurableName = commandDestination.substring(commandDestination.indexOf("/") + 1);
        }
        if ((configurable = (Configurable)this.lookup.getComponentByName(configurableName)) == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName + " for command destination");
        }
        return configurable;
    }

    protected LocalCommandDictionary getCommandBuilder(Object object) {
        if (object instanceof Configurable) {
            Configurable configurable = (Configurable)object;
            Configurable.Environment env = configurable.getEnvironment();
            LocalCommandDictionary res = env.getCommandBuilder();
            env.getNameOfComponent();
            return res;
        }
        return super.getCommandBuilder(object);
    }

    protected Subsystem.DictionarySearchResult searchForDictionary(org.lsst.ccs.bus.Command command) throws CommandInvocationException {
        Configurable goal = this.getCommandDestination(command.getDestination());
        LocalCommandDictionary localDict = this.getCommandBuilder(goal);
        if (goal.getEnvironment().getNameOfComponent().equals("main")) {
            Subsystem.DictionarySearchResult searchDict = this.searchForDictionary(false, command, goal, localDict);
            if (searchDict == null) {
                return super.searchForDictionary(command);
            }
            if (searchDict.method != null) {
                return searchDict;
            }
            return super.searchForDictionary(command);
        }
        return this.searchForDictionary(true, command, goal, localDict);
    }

    @Command(description="halt", type=Command.CommandType.ABORT)
    public void abort() {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.ABORT)
    public void abort(long expectedMaxDelay) {
        super.abort();
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.HALT, expectedMaxDelay));
    }

    @Command(description="stops with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        super.stop(expectedMaxDelay);
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        mainModule.percolateSignal(new Signal(SignalLevel.STOP, expectedMaxDelay));
    }

    @Command(description="stops hardware", type=Command.CommandType.ACTION)
    public void stop() throws HardwareException {
        this.stop(Long.MAX_VALUE);
    }

    public void checkAllHardwareStarted() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        NodesFunction activeFunc = new NodesFunction(){
            {
                this.result = null;
            }

            public TreeWalkerDiag evalOn(Configurable configurable) {
                block3: {
                    if (configurable instanceof HardwareController) {
                        try {
                            ((HardwareController)configurable).checkStarted();
                        }
                        catch (HardwareException e) {
                            this.result = new HardwareException(String.valueOf(configurable.toString()) + " not started", (Throwable)e, (HardwareException)((Object)this.result));
                            if (!e.isFatal()) break block3;
                            return TreeWalkerDiag.STOP;
                        }
                    }
                }
                return TreeWalkerDiag.GO;
            }
        };
        NodeTreeWalker walker = new NodeTreeWalker((NodeCommand)activeFunc);
        walker.invokeOn((Configurable)mainModule);
        HardwareException exc = (HardwareException)((Object)activeFunc.getResult());
        if (exc != null) {
            throw exc;
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        Module mainModule = (Module)this.lookup.getComponentByName("main");
        if (mainModule == null) {
            throw new IllegalArgumentException("no component named main!");
        }
        NodesFunction activeFunc = new NodesFunction(){
            {
                this.result = null;
            }

            public TreeWalkerDiag evalOn(Configurable configurable) {
                block3: {
                    if (configurable instanceof HardwareController) {
                        try {
                            ((HardwareController)configurable).checkStopped();
                        }
                        catch (HardwareException e) {
                            this.result = new HardwareException(String.valueOf(configurable.toString()) + " not stopped", (Throwable)e, (HardwareException)((Object)this.result));
                            if (!e.isFatal()) break block3;
                            return TreeWalkerDiag.STOP;
                        }
                    }
                }
                return TreeWalkerDiag.GO;
            }
        };
        NodeTreeWalker walker = new NodeTreeWalker((NodeCommand)activeFunc);
        walker.invokeOn((Configurable)mainModule);
        HardwareException exc = (HardwareException)((Object)activeFunc.getResult());
        if (exc != null) {
            throw exc;
        }
    }

    public void registerNodes(ComponentNode node) {
        this.lookup = new NodeLookup(node);
        Iterator iter = node.getAllKeys();
        if (iter != null) {
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = node.getIndirect((Object)key);
                if (value instanceof Module) {
                    this.registerConfigurable(key, (Configurable)value);
                    continue;
                }
                if (!(value instanceof Configurable)) continue;
                this.registerConfigurable(key, (Configurable)value);
            }
        }
        this.realRegisterNodes(node);
    }

    private void realRegisterNodes(ComponentNode node) {
        ArrayList children = node.getChildren();
        if (children != null) {
            for (ComponentNode child : children) {
                this.realRegisterNodes(child);
            }
        }
        String key = node.getKey();
        Object value = node.getRealValue();
        if (value instanceof Configurable) {
            Configurable configurable = (Configurable)value;
            configurable.setEnvironment(new Configurable.Environment(key, configurable, this.configurationProxy, this.lookup));
            if (value instanceof Module) {
                this.rawInitModule((Module)value);
            }
        }
    }
}

