/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesTree;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public abstract class BootstrapUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    protected static final String DISTRIBUTION_JARS_DIRECTORY = "share" + FILE_SEPARATOR + "java" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_RESOURCES_DIRECTORY = "etc" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_LIB_DIRECTORY = "lib" + FILE_SEPARATOR;
    private static final String DISTRIBUTION_JNI_DIRECTORY = String.valueOf(DISTRIBUTION_LIB_DIRECTORY) + "jni" + FILE_SEPARATOR;
    protected static final String APPLICATION_MAINCLASS_PROPERTY = "org.lsst.ccs.application.mainClass";
    protected static final String OBSOLETE_MAINJAR_PROPERTY = "org.lsst.ccs.application.mainJar";
    private static List<String> listOfApplications = null;
    private static final String envVar_str_pattern = ".*(\\$\\[env\\.(.*)\\]).*";
    private static final Pattern envVar_pattern = Pattern.compile(".*(\\$\\[env\\.(.*)\\]).*");
    static final String CCS_RESOURCE_PATH_ENV_VAR = "CCS_RESOURCE_PATH";
    static final String CCS_DISTRIBUTION_PATH_ENV_VAR = "CCS_DISTRIBUTION_PATH";
    private static String ccsDistributionRootDirectory = null;
    private static ResourcesTree resourcesTree = null;

    protected static void reset() {
        resourcesTree = null;
        ccsDistributionRootDirectory = null;
        listOfApplications = null;
    }

    public static synchronized ResourcesTree getBootstrapResourcesTree() {
        if (resourcesTree == null) {
            resourcesTree = new ResourcesTree();
            List<String> resourceDirectories = BootstrapUtils.getOrderedListOfResourceDirectories();
            for (String resourceDirectory : resourceDirectories) {
                File resourceDir = new File(resourceDirectory);
                if (resourceDir.exists()) {
                    resourcesTree.addResourceDirectory(resourceDirectory);
                    continue;
                }
                if (!Bootstrap.isBootstrapEnvironment()) continue;
                System.out.println("***** WARNING: resource directory " + resourceDirectory + " does not exist.");
            }
        }
        return resourcesTree;
    }

    static List<String> getOrderedListOfResourceDirectories() {
        String userProvidedResourceDirs = System.getenv(CCS_RESOURCE_PATH_ENV_VAR);
        String userProvidedDistributionDirs = System.getenv(CCS_DISTRIBUTION_PATH_ENV_VAR);
        return BootstrapUtils.getOrderedListOfResourceDirectories(userProvidedResourceDirs, userProvidedDistributionDirs, true);
    }

    public static List<String> getOrderedListOfResourceDirectories(String userProvidedResourceDirs, String userProvidedDistributions, boolean checkExistance) {
        String distributionResourceDirectoriy = BootstrapUtils.getDistributionResourcesDirectory();
        List<String> additionaDistributionResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedDistributions, DISTRIBUTION_RESOURCES_DIRECTORY, checkExistance);
        List<String> additionalResourceDirectories = BootstrapUtils.extractDirectoriesFromPath(userProvidedResourceDirs, null, checkExistance);
        ArrayList<String> orderedListOfResourceDirectories = new ArrayList<String>();
        for (String dir : additionalResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        orderedListOfResourceDirectories.add(distributionResourceDirectoriy);
        for (String dir : additionaDistributionResourceDirectories) {
            orderedListOfResourceDirectories.add(dir);
        }
        return orderedListOfResourceDirectories;
    }

    static List<String> extractDirectoriesFromPath(String directoryPath, String appendDirectory, boolean checkExistance) {
        ArrayList<String> extractedDirectories = new ArrayList<String>();
        if (directoryPath != null && !"".equals(directoryPath)) {
            StringTokenizer dirsToken = new StringTokenizer(directoryPath, PATH_SEPARATOR);
            while (dirsToken.hasMoreTokens()) {
                String resourceDir = dirsToken.nextToken().trim();
                if (!resourceDir.endsWith(FILE_SEPARATOR)) {
                    resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
                }
                if (appendDirectory != null && !"".equals(appendDirectory)) {
                    if (!appendDirectory.endsWith(FILE_SEPARATOR)) {
                        appendDirectory = String.valueOf(appendDirectory) + FILE_SEPARATOR;
                    }
                    resourceDir = String.valueOf(resourceDir) + appendDirectory;
                }
                Path p = Paths.get(BootstrapUtils.getCCSDistributionRootDirectory(), new String[0]);
                resourceDir = resourceDir.replace("~", System.getProperty("user.home"));
                if (!(resourceDir = p.resolve(resourceDir).normalize().toString()).endsWith(FILE_SEPARATOR)) {
                    resourceDir = String.valueOf(resourceDir) + FILE_SEPARATOR;
                }
                File dir = new File(resourceDir);
                if (checkExistance && !dir.exists()) {
                    if (!Bootstrap.isBootstrapEnvironment()) continue;
                    System.out.println("** Ignoring resource directory " + resourceDir + " as it does not exist.");
                    System.out.println("** Please update the environment variable CCS_RESOURCE_PATH or CCS_DISTRIBUTION_PATH");
                    continue;
                }
                extractedDirectories.add(resourceDir);
            }
        }
        return extractedDirectories;
    }

    public static String getDistributionResourcesDirectory() {
        return BootstrapUtils.getDistributionResourcesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionResourcesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_RESOURCES_DIRECTORY;
    }

    static String getDistributionLibDirectory() {
        return BootstrapUtils.getDistributionLibDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionLibDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_LIB_DIRECTORY;
    }

    static String getDistributionJniDirectory() {
        return BootstrapUtils.getDistributionJniDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJniDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JNI_DIRECTORY;
    }

    static String getDistributionJarFilesDirectory() {
        return BootstrapUtils.getDistributionJarFilesDirectory(BootstrapUtils.getCCSDistributionRootDirectory());
    }

    static String getDistributionJarFilesDirectory(String distribution) {
        if (!distribution.endsWith(FILE_SEPARATOR)) {
            distribution = String.valueOf(distribution) + FILE_SEPARATOR;
        }
        return String.valueOf(distribution) + DISTRIBUTION_JARS_DIRECTORY;
    }

    public static String getCCSDistributionRootDirectory() {
        if (ccsDistributionRootDirectory == null) {
            ccsDistributionRootDirectory = BootstrapUtils.getCCSDistributionRootDirectory(BootstrapUtils.class);
        }
        return ccsDistributionRootDirectory;
    }

    static String getCCSDistributionRootDirectory(Class clazz) {
        block5: {
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            try {
                Path path = Paths.get(location.toURI());
                String sourceCodeLocation = path.toString();
                if (sourceCodeLocation.endsWith(".jar")) {
                    ccsDistributionRootDirectory = sourceCodeLocation.substring(0, sourceCodeLocation.lastIndexOf(FILE_SEPARATOR) + 1);
                    break block5;
                }
                if (path.toFile().isDirectory()) {
                    ccsDistributionRootDirectory = String.valueOf(sourceCodeLocation) + FILE_SEPARATOR;
                    break block5;
                }
                throw new RuntimeException("Could not process souce code location " + sourceCodeLocation + " It is neither a directory nor a jar file.");
            }
            catch (URISyntaxException x) {
                throw new RuntimeException("Could not process souce code location ", x);
            }
        }
        if (ccsDistributionRootDirectory.endsWith(DISTRIBUTION_JARS_DIRECTORY)) {
            ccsDistributionRootDirectory = ccsDistributionRootDirectory.replace(DISTRIBUTION_JARS_DIRECTORY, "");
        }
        return ccsDistributionRootDirectory;
    }

    public static synchronized List<String> getBootstrapListOfApplications() {
        if (listOfApplications == null) {
            listOfApplications = new ArrayList<String>();
            List<String> allPropertiesInResources = ResourcesUtils.getResourcesInResourcesTreeByExtension(BootstrapUtils.getBootstrapResourcesTree(), "properties", 0);
            for (String propertyFile : allPropertiesInResources) {
                Properties props = ResourcesUtils.getMergedPropertyFile(BootstrapUtils.getBootstrapResourcesTree(), propertyFile);
                String mainClass = props.getProperty(APPLICATION_MAINCLASS_PROPERTY);
                if (mainClass == null || mainClass.isEmpty()) continue;
                listOfApplications.add(propertyFile.replace(".properties", ""));
            }
        }
        return listOfApplications;
    }

    static Properties getApplicationDefinitionProperties(String application) {
        return BootstrapResourceUtils.getBootstrapProperties(application);
    }

    static String getBootstrapLibraryPath() {
        String libraryPath = String.valueOf(BootstrapUtils.getDistributionJniDirectory()) + File.pathSeparator + BootstrapUtils.getDistributionLibDirectory();
        String existingLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (existingLibraryPath != null && !existingLibraryPath.isEmpty()) {
            libraryPath = String.valueOf(libraryPath) + File.pathSeparator + existingLibraryPath;
        }
        return libraryPath;
    }

    public static String parseProperty(String inputProperty) {
        String outProperty = inputProperty;
        Matcher m = envVar_pattern.matcher(outProperty);
        if (m.matches()) {
            String envVarValue = System.getenv(m.group(2));
            if (envVarValue != null) {
                outProperty = outProperty.replace(m.group(1), envVarValue);
            } else if (Bootstrap.isBootstrapEnvironment()) {
                System.out.println("[WARNING] Environment variable " + m.group(2) + " is not defined.");
            }
        }
        return outProperty;
    }
}

