/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3.console;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.plugin.jas3.console.MessageFilter;
import org.lsst.ccs.plugin.jas3.console.RegularExpressionMessageFilter;
import org.lsst.ccs.plugin.jas3.console.RegularExpressionMessageFilterPanel;

public class Tracer
implements PageListener,
StatusListener,
HasPopupItems {
    private final MessagingFactory factory;
    private PrintWriter out;
    private MessageFilter filter = new RegularExpressionMessageFilter();

    Tracer(MessagingFactory factory) {
        this.factory = factory;
    }

    public void onStatus(BusMessage bm) {
        if (this.filter == null || this.filter.accept(bm)) {
            this.out.println(bm);
        }
    }

    public void pageChanged(PageEvent pe) {
        if (pe.getID() == 4001) {
            this.factory.removeStatusListener((StatusListens)this);
        }
    }

    void start(PrintWriter out) {
        this.out = out;
        this.factory.addStatusListener((StatusListens)this);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JMenuItem item = new JMenuItem("Set Filter...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegularExpressionMessageFilter regexFilter = (RegularExpressionMessageFilter)Tracer.this.filter;
                RegularExpressionMessageFilterPanel fp = new RegularExpressionMessageFilterPanel(regexFilter);
                int rc = JOptionPane.showConfirmDialog((Component)Application.getApplication(), fp, "Select Filter", 2);
                if (rc == 0) {
                    fp.apply();
                }
            }
        });
        menu.insert(item, 0);
        return menu;
    }
}

