/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginMap;
import org.freehep.application.studio.pluginmanager.PluginManager;

public class PluginPreferences {
    protected PluginManager manager;
    protected String keyPrefix = "PluginManager.";
    protected String urlKey = "URL";
    protected String snapshotsKey = "snapshots";
    protected String checkAtStartKey = "checkForPluginsAtStart";
    protected String orphanActionKey = "orphanAction";
    protected String orphanPromptKey = "orphanPrompt";
    protected String notifyPluginUpdatesKey = "notifyPluginUpdates";
    protected String downloadMissingKey = "downloadMissing";
    protected URL urlDefault;
    protected boolean snapshotsDefault = false;
    protected boolean checkAtStartDefault = true;
    protected PluginMap.Orphan orphanActionDefault = PluginMap.Orphan.Remove;
    protected boolean orphanPromptDefault = true;
    protected boolean notifyPluginUpdatesDefault = true;
    protected boolean downloadMissingDefault = true;
    protected URL url;
    protected boolean snapshots;
    protected boolean checkAtStart;
    protected PluginMap.Orphan orphanAction;
    protected boolean orphanPrompt;
    protected boolean notifyPluginUpdates;
    protected boolean downloadMissing;

    public PluginPreferences(PluginManager manager, boolean restore) {
        this.manager = manager;
        if (restore) {
            this.restore();
        }
    }

    protected final void restore() {
        Properties prop = this.manager.getApplication().getUserProperties();
        this.url = PropertyUtilities.getURL(prop, this.keyPrefix + this.urlKey, this.urlDefault);
        this.snapshots = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.snapshotsKey, this.snapshotsDefault);
        this.checkAtStart = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.checkAtStartKey, this.checkAtStartDefault);
        try {
            this.orphanAction = PluginMap.Orphan.valueOf(PropertyUtilities.getString(prop, this.keyPrefix + this.orphanActionKey, this.orphanActionDefault.name()));
        }
        catch (IllegalArgumentException x) {
            this.orphanAction = this.orphanActionDefault;
        }
        this.orphanPrompt = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.orphanPromptKey, this.orphanPromptDefault);
        this.notifyPluginUpdates = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.notifyPluginUpdatesKey, this.notifyPluginUpdatesDefault);
        this.downloadMissing = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.downloadMissingKey, this.downloadMissingDefault);
    }

    protected void save() {
        Properties prop = this.manager.getApplication().getUserProperties();
        PropertyUtilities.setURL(prop, this.keyPrefix + this.urlKey, this.url);
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.snapshotsKey, this.snapshots == this.snapshotsDefault ? null : Boolean.valueOf(this.snapshots));
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.checkAtStartKey, this.checkAtStart == this.checkAtStartDefault ? null : Boolean.valueOf(this.checkAtStart));
        PropertyUtilities.setString(prop, this.keyPrefix + this.orphanActionKey, this.orphanAction == this.orphanActionDefault ? null : this.orphanAction.name());
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.orphanPromptKey, this.orphanPrompt == this.orphanPromptDefault ? null : Boolean.valueOf(this.orphanPrompt));
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.notifyPluginUpdatesKey, this.notifyPluginUpdates == this.notifyPluginUpdatesDefault ? null : Boolean.valueOf(this.notifyPluginUpdates));
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.downloadMissingKey, this.downloadMissing == this.downloadMissingDefault ? null : Boolean.valueOf(this.downloadMissing));
    }

    public URL getUrl() {
        if (this.snapshots && this.urlDefault.equals(this.url)) {
            try {
                return new URL(this.urlDefault.toString() + "?snapshots=true");
            }
            catch (MalformedURLException x) {
                return this.url;
            }
        }
        return this.url;
    }

    public boolean isSnapshots() {
        return this.snapshots;
    }

    public boolean isCheckAtStart() {
        return this.checkAtStart;
    }

    public PluginMap.Orphan getOrphanAction() {
        return this.orphanAction;
    }

    public boolean isOrphanPrompt() {
        return this.orphanPrompt;
    }

    public boolean isNotifyPluginUpdates() {
        return this.isCheckAtStart();
    }

    public boolean isDownloadMissing() {
        return this.downloadMissing;
    }

    public void setUrl(URL url, boolean save) {
        this.url = url;
        if (save) {
            PropertyUtilities.touchURL(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.urlKey, url);
        }
    }

    public void setSnapshots(boolean snapshots, boolean save) {
        this.snapshots = snapshots;
        if (save) {
            PropertyUtilities.touchBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.snapshotsKey, snapshots);
        }
    }

    public void setCheckAtStart(boolean checkAtStart, boolean save) {
        this.checkAtStart = checkAtStart;
        if (save) {
            PropertyUtilities.touchBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.checkAtStartKey, checkAtStart);
        }
    }

    public void setOrphanAction(PluginMap.Orphan orphanAction, boolean save) {
        this.orphanAction = orphanAction;
        if (save) {
            PropertyUtilities.touchString(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.orphanActionKey, orphanAction.name());
        }
    }

    public void setOrphanPrompt(boolean orphanPrompt, boolean save) {
        this.orphanPrompt = orphanPrompt;
        if (save) {
            PropertyUtilities.touchBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.orphanPromptKey, orphanPrompt);
        }
    }

    public void setNotifyPluginUpdates(boolean notifyPluginUpdates, boolean save) {
        this.notifyPluginUpdates = notifyPluginUpdates;
        if (save) {
            PropertyUtilities.touchBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.notifyPluginUpdatesKey, notifyPluginUpdates);
        }
    }

    public void setDownloadMissing(boolean downloadMissing, boolean save) {
        this.downloadMissing = downloadMissing;
        if (save) {
            PropertyUtilities.touchBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.downloadMissingKey, downloadMissing);
        }
    }

    protected String getDescription(PluginMap.Orphan action) {
        if (action == null) {
            return "<html>Prompt me every time unclaimed libraries are detected.</html>";
        }
        switch (action) {
            case Remove: {
                return "<html>Recommended. Unclaimed library files will be deleted.</html>";
            }
            case Ignore: {
                return "<html>Unclaimed library files will not be deleted but classes <br>they contain will remain inaccessible to the application. <br>It will be possible to load or delete these libraries later through <br>the plugin manager.</html>";
            }
            case Load: {
                return "<html>Libraries found in the extensions directories will be added to <br>the classpath whether or not they are claimed by any installed plugins. <br>This can be convenient when developing new plugins, <br>but it may affect application performance and result in unpredictable behavior, <br>depending on the content of the loaded libraries.</html>";
            }
        }
        return "<html>Prompt me every time unclaimed libraries are detected.</html>";
    }

    public JComponent getPreferencesPanel() {
        return new GUI();
    }

    public boolean apply(JComponent gui) {
        try {
            URL oldURL = this.url;
            boolean oldSnap = this.snapshots;
            boolean out = ((GUI)gui).get();
            if (out && this.url != null && (!this.url.equals(oldURL) || oldSnap != this.snapshots)) {
                this.manager.startPluginListDownload();
            }
            this.save();
            return out;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    public PluginMap.Orphan verifyOrphanAction(EnumMap<PluginDir, ArrayList<LibInfo>> unclaimedLibraries) {
        if (!this.orphanPrompt || unclaimedLibraries == null || unclaimedLibraries.isEmpty()) {
            return this.orphanAction;
        }
        GUIorphan gui = new GUIorphan(unclaimedLibraries);
        JScrollPane pane = new JScrollPane(gui);
        pane.setVerticalScrollBarPolicy(20);
        pane.setPreferredSize(new Dimension(600, 600));
        JOptionPane.showMessageDialog(this.manager.getApplication(), pane, "Unclaimed librarries found", -1);
        PluginMap.Orphan action = gui.getAction();
        this.setOrphanAction(action, true);
        if (gui.getRemember()) {
            this.setOrphanPrompt(false, true);
        }
        return action;
    }

    protected class GUIorphan
    extends JPanel {
        protected int HSPACE = 10;
        protected int VSPACE = 5;
        protected int HPAD = 25;
        protected ButtonGroup _orphanGroup;
        protected JCheckBox _orphanBox;

        GUIorphan(EnumMap<PluginDir, ArrayList<LibInfo>> unclaimedLibraries) {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(this.HSPACE, this.VSPACE, this.HSPACE, this.VSPACE));
            StringBuilder sb = new StringBuilder();
            sb.append("<html>The following libraries found in the application extensions<br> directories are not referenced by any installed plugins:<br/>&ensp;");
            for (Map.Entry<PluginDir, ArrayList<LibInfo>> entry : unclaimedLibraries.entrySet()) {
                PluginDir dir = entry.getKey();
                sb.append("<p><b>").append(dir.getLabel()).append(" directory : </b>");
                sb.append(PluginPreferences.this.manager.getApplication().getExtensionsDir(dir)).append("</p><ul>");
                for (LibInfo lib : entry.getValue()) {
                    sb.append("<li>").append(lib.getLocation()).append("</li>");
                }
            }
            sb.append("</ul>How would you like to treat them ?</br> </html>");
            JLabel label = new JLabel(sb.toString());
            this.add(label);
            this.add(Box.createRigidArea(new Dimension(0, this.VSPACE)));
            Box panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createEtchedBorder());
            panel.setAlignmentX(0.0f);
            this._orphanGroup = new ButtonGroup();
            for (PluginMap.Orphan action : PluginMap.Orphan.values()) {
                JRadioButton radio = new JRadioButton(action.name());
                radio.setActionCommand(action.name());
                radio.setFont(radio.getFont().deriveFont(1));
                radio.setSelected(PluginPreferences.this.orphanAction == PluginMap.Orphan.Remove);
                radio.setAlignmentX(0.0f);
                this._orphanGroup.add(radio);
                panel.add(radio);
                label = new JLabel(PluginPreferences.this.getDescription(action));
                label.setBorder(BorderFactory.createEmptyBorder(0, this.HPAD, this.VSPACE, 0));
                this.add(label);
                panel.add(label);
            }
            this.add(panel);
            this._orphanBox = new JCheckBox("Remember my choice");
            this._orphanBox.setSelected(false);
            this._orphanBox.setAlignmentX(0.0f);
            this.add(this._orphanBox);
        }

        final PluginMap.Orphan getAction() {
            return PluginMap.Orphan.valueOf(this._orphanGroup.getSelection().getActionCommand());
        }

        final boolean getRemember() {
            return this._orphanBox.isSelected();
        }
    }

    protected class GUI
    extends JPanel {
        protected int HSPACE = 10;
        protected int VSPACE = 5;
        protected JCheckBox _snapshotsBox;
        protected JCheckBox _checkAtStartBox;
        protected JCheckBox _downloadMissingBox;
        protected JTextField _urlField;
        protected JButton _urlButton;
        protected ButtonGroup _orphanGroup;
        protected EnumMap<PluginMap.Orphan, JRadioButton> _orphanButtons;
        protected JRadioButton _promptButton;
        protected boolean _checkAtStartBoxState;

        GUI() {
            this.setLayout(new BoxLayout(this, 1));
            Box panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Plugin catalog"));
            panel.setAlignmentX(0.0f);
            Box row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("URL: "));
            this._urlField = new JTextField(8);
            this._urlField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this._urlField.getPreferredSize().height));
            this._urlField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent fe) {
                    String text = GUI.this._urlField.getText().trim();
                    if (text.isEmpty()) {
                        GUI.this._checkAtStartBox.setEnabled(false);
                        GUI.this._checkAtStartBox.setSelected(false);
                        GUI.this._snapshotsBox.setEnabled(false);
                    } else {
                        GUI.this._checkAtStartBox.setEnabled(true);
                        GUI.this._checkAtStartBox.setSelected(GUI.this._checkAtStartBoxState);
                        GUI.this._snapshotsBox.setEnabled(true);
                    }
                }
            });
            row.add(this._urlField);
            row.add(Box.createRigidArea(new Dimension(this.HSPACE, 0)));
            this._urlButton = new JButton("Default");
            this._urlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GUI.this._urlField.setText(PluginPreferences.this.urlDefault == null ? "" : PluginPreferences.this.urlDefault.toString());
                }
            });
            row.add(this._urlButton);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this._snapshotsBox = new JCheckBox("Include snapshot versions of plugins");
            this._snapshotsBox.setAlignmentX(0.0f);
            this._snapshotsBox.setToolTipText("Uncheck to ignore snapshots.");
            panel.add(this._snapshotsBox);
            panel.add(Box.createRigidArea(new Dimension(0, this.VSPACE)));
            this._checkAtStartBox = new JCheckBox("Check for updated plugins at startup");
            this._checkAtStartBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUI.this._checkAtStartBoxState = GUI.this._checkAtStartBox.isSelected();
                }
            });
            this._checkAtStartBox.setAlignmentX(0.0f);
            this._checkAtStartBox.setToolTipText("<html>Check to download the list of available plugins at startup.<br> The list will be used to offer updates and download missing plugin dependencies.</html>");
            panel.add(this._checkAtStartBox);
            panel.add(Box.createRigidArea(new Dimension(0, this.VSPACE)));
            this._downloadMissingBox = new JCheckBox("Download missing libraries");
            this._downloadMissingBox.setAlignmentX(0.0f);
            this._downloadMissingBox.setToolTipText("<html>Check to attempt downloading any missing libraries referenced by installed plugins when the application starts.</html>");
            panel.add(this._downloadMissingBox);
            panel.add(Box.createRigidArea(new Dimension(0, this.VSPACE)));
            this.add(panel);
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Handling of unclaimed libraries"));
            panel.setAlignmentX(0.0f);
            panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, panel.getMaximumSize().height));
            panel.setToolTipText("<html>Choose how to handle libraries found in the application extensions<br> directories if they are not referenced by any installed plugins.</html>");
            this._orphanGroup = new ButtonGroup();
            this._orphanButtons = new EnumMap(PluginMap.Orphan.class);
            JRadioButton radio = new JRadioButton("Remove  (recommended)");
            radio.setActionCommand(PluginMap.Orphan.Remove.name());
            radio.setToolTipText(PluginPreferences.this.getDescription(PluginMap.Orphan.Remove));
            this._orphanButtons.put(PluginMap.Orphan.Remove, radio);
            this._orphanGroup.add(radio);
            panel.add(radio);
            radio = new JRadioButton(PluginMap.Orphan.Ignore.name());
            radio.setActionCommand(PluginMap.Orphan.Ignore.name());
            radio.setToolTipText(PluginPreferences.this.getDescription(PluginMap.Orphan.Ignore));
            this._orphanButtons.put(PluginMap.Orphan.Ignore, radio);
            this._orphanGroup.add(radio);
            panel.add(radio);
            radio = new JRadioButton("Load  (dangerous, use at your own risk) ");
            radio.setActionCommand(PluginMap.Orphan.Load.name());
            radio.setToolTipText(PluginPreferences.this.getDescription(PluginMap.Orphan.Load));
            this._orphanButtons.put(PluginMap.Orphan.Load, radio);
            this._orphanGroup.add(radio);
            panel.add(radio);
            this._promptButton = new JRadioButton("Prompt");
            this._promptButton.setToolTipText(PluginPreferences.this.getDescription(null));
            this._orphanGroup.add(this._promptButton);
            panel.add(this._promptButton);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, this.VSPACE)));
            this.add(Box.createVerticalGlue());
            this.set();
        }

        final boolean get() {
            PluginPreferences.this.snapshots = this._snapshotsBox.isSelected();
            String urlText = this._urlField.getText().trim();
            if (urlText.isEmpty()) {
                PluginPreferences.this.url = null;
            } else {
                try {
                    PluginPreferences.this.url = new URL(urlText);
                }
                catch (MalformedURLException x) {
                    if (PluginPreferences.this.url == null) {
                        this._urlField.setText("");
                        this._snapshotsBox.setEnabled(false);
                        this._checkAtStartBox.setSelected(false);
                        this._checkAtStartBox.setEnabled(false);
                    } else {
                        this._urlField.setText(PluginPreferences.this.url.toString());
                        this._snapshotsBox.setEnabled(true);
                        this._checkAtStartBox.setSelected(this._checkAtStartBoxState);
                        this._checkAtStartBox.setEnabled(true);
                    }
                    return false;
                }
            }
            PluginPreferences.this.checkAtStart = this._checkAtStartBoxState;
            PluginPreferences.this.downloadMissing = this._downloadMissingBox.isSelected();
            try {
                String s = this._orphanGroup.getSelection().getActionCommand();
                PluginPreferences.this.orphanAction = PluginMap.Orphan.valueOf(this._orphanGroup.getSelection().getActionCommand());
                PluginPreferences.this.orphanPrompt = false;
            }
            catch (NullPointerException x) {
                PluginPreferences.this.orphanAction = PluginMap.Orphan.Remove;
                PluginPreferences.this.orphanPrompt = true;
            }
            return true;
        }

        final void set() {
            this._snapshotsBox.setSelected(PluginPreferences.this.snapshots);
            this._checkAtStartBoxState = PluginPreferences.this.checkAtStart;
            this._downloadMissingBox.setSelected(PluginPreferences.this.downloadMissing);
            if (PluginPreferences.this.url == null) {
                this._snapshotsBox.setEnabled(false);
                this._checkAtStartBox.setSelected(false);
                this._checkAtStartBox.setEnabled(false);
                this._urlField.setText("");
            } else {
                this._snapshotsBox.setEnabled(true);
                this._checkAtStartBox.setSelected(PluginPreferences.this.checkAtStart);
                this._checkAtStartBox.setEnabled(true);
                this._urlField.setText(PluginPreferences.this.url.toString());
            }
            if (PluginPreferences.this.orphanPrompt) {
                this._promptButton.setSelected(true);
            } else {
                this._orphanButtons.get((Object)PluginPreferences.this.orphanAction).setSelected(true);
            }
        }
    }
}

