/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.freehep.application.Application;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.PluginMap;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.pluginmanager.PluginDownload;
import org.freehep.application.studio.pluginmanager.PluginListHandler;
import org.freehep.application.studio.pluginmanager.PluginManagerDialog;
import org.freehep.application.studio.pluginmanager.PluginPreferences;
import org.freehep.util.VersionComparator;
import org.xml.sax.SAXException;

public class PluginManager
extends Plugin
implements Runnable {
    protected PluginPreferences preferences;
    private final Object pluginListLock = new Object();
    protected PluginListHandler pluginListHandler;
    protected volatile Thread pluginListReaderThread;
    protected volatile boolean pluginListIsReady = false;
    protected Map<String, PluginInfo> availablePlugins;
    private final CountDownLatch updateLatch = new CountDownLatch(1);
    protected ArrayList<PluginInfo> installablePlugins;
    protected ArrayList<PluginInfo> updatablePlugins;
    protected Map<PluginInfo, PluginInfo> updateMap;
    protected PluginMap masterMap;
    protected boolean dialogVisible = false;
    private EventListenerList listeners = new EventListenerList();
    static final Logger logger = null;

    @Override
    protected void init() throws SAXException, IOException {
        List<LibInfo> missing;
        this.masterMap = this.getApplication().getPluginMap();
        this.preferences = this.makePreferences();
        this.pluginListIsReady = false;
        if ((this.preferences.isCheckAtStart() || this.preferences.isDownloadMissing()) && this.preferences.getUrl() != null) {
            this.startPluginListDownload();
        } else if (this.preferences.isDownloadMissing() && !(missing = this.masterMap.getMissingLibraries()).isEmpty()) {
            this.download(this.getApplication(), this.masterMap.getDownloads(missing, false));
        }
    }

    @Override
    protected void applicationVisible() {
        EnumMap<PluginDir, ArrayList<LibInfo>> unclaimed;
        this.preferences = this.makePreferences();
        PluginMap.Orphan orphanAction = this.preferences.getOrphanAction();
        if (this.preferences.isOrphanPrompt() && !(unclaimed = this.masterMap.getUnclaimedLibraries()).isEmpty()) {
            orphanAction = this.preferences.verifyOrphanAction(unclaimed);
        }
        this.masterMap.processUnclaimedLibraries(orphanAction);
        this.masterMap.purge();
        this.updateLatch.countDown();
    }

    protected PluginPreferences makePreferences() {
        return new PluginPreferences(this, true);
    }

    public PluginPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.makePreferences();
        }
        return this.preferences;
    }

    protected boolean isPluginListIsReady() {
        return this.pluginListIsReady;
    }

    protected PluginMap getPluginMap() {
        return this.masterMap;
    }

    protected Map<String, PluginInfo> getAvailablePlugins() {
        return this.pluginListIsReady ? Collections.unmodifiableMap(this.availablePlugins) : Collections.emptyMap();
    }

    Map<PluginInfo, PluginInfo> getUpdateMap() {
        if (!this.pluginListIsReady) {
            return null;
        }
        if (this.updateMap == null) {
            this.processAvailablePlugins();
        }
        return this.updateMap;
    }

    protected Map<String, PluginInfo> getActivePlugins() {
        return this.masterMap.getActivePlugins();
    }

    List<PluginInfo> getInstallablePlugins() {
        if (!this.pluginListIsReady) {
            return null;
        }
        if (this.installablePlugins == null) {
            this.processAvailablePlugins();
        }
        return this.installablePlugins;
    }

    List<PluginInfo> getUpdatablePlugins() {
        if (!this.pluginListIsReady) {
            return null;
        }
        if (this.updatablePlugins == null) {
            this.processAvailablePlugins();
        }
        return this.updatablePlugins;
    }

    public void setPluginListHandler(PluginListHandler pluginListHandler) {
        this.pluginListHandler = pluginListHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPluginManager() {
        if (!this.pluginListIsReady && this.pluginListReaderThread == null) {
            this.startPluginListDownload();
        }
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.getApplication());
        PluginManagerDialog dlg = new PluginManagerDialog(frame, this);
        dlg.setModal(true);
        dlg.setTitle("Plugin Manager");
        dlg.pack();
        dlg.setLocationRelativeTo(this.getApplication());
        try {
            this.dialogVisible = true;
            dlg.setVisible(true);
        }
        finally {
            this.dialogVisible = false;
            this.cleanup();
        }
    }

    public void offerUpdate() {
        Box message = Box.createVerticalBox();
        JLabel label = new JLabel("Updated plugins available");
        label.setAlignmentX(1.0f);
        message.add(label);
        JCheckBox ask = new JCheckBox("Don't show me this again");
        message.add(ask);
        Object[] options = new String[]{"Install now", "Plugin Manager...", "Cancel"};
        int rc = JOptionPane.showOptionDialog(this.getApplication(), message, "Updates available", 1, 1, null, options, options[0]);
        if (ask.isSelected()) {
            this.preferences.setNotifyPluginUpdates(false, true);
        }
        if (rc == 0) {
            this.update(this.getApplication());
        } else if (rc == 1) {
            this.showPluginManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startPluginListDownload() {
        Object object = this.pluginListLock;
        synchronized (object) {
            this.pluginListIsReady = false;
            this.pluginListReaderThread = new Thread(this);
            this.pluginListReaderThread.setDaemon(true);
            this.pluginListReaderThread.setPriority(5);
            this.pluginListReaderThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PluginListHandler handler = this.pluginListHandler == null ? new PluginListHandler() : this.pluginListHandler;
        List<PluginInfo> available = handler.getAvailablePlugins(this.preferences.getUrl(), logger, this.getApplication());
        LinkedHashMap<String, PluginInfo> availableMap = new LinkedHashMap<String, PluginInfo>((int)((float)available.size() * 1.5f) + 1);
        Studio studio = this.getApplication();
        boolean keepSnapshots = this.preferences.isSnapshots();
        for (PluginInfo plugin : available) {
            PluginInfo prev;
            if (studio.isBlacklisted(plugin) || !keepSnapshots && plugin.getVersion().contains("SNAPSHOT") || !plugin.isApplicationCompatible(this.getApplication()) || !plugin.isJavaCompatible() || (prev = availableMap.put(plugin.getName(), plugin)) == null || VersionComparator.compareVersion((String)prev.getVersion(), (String)plugin.getVersion()) <= 0) continue;
            availableMap.put(prev.getName(), prev);
        }
        try {
            this.updateLatch.await();
        }
        catch (InterruptedException x) {
            return;
        }
        Object object = this.pluginListLock;
        synchronized (object) {
            if (this.pluginListReaderThread == Thread.currentThread()) {
                this.availablePlugins = availableMap;
                this.pluginListReaderThread = null;
                SwingUtilities.invokeLater(new PluginListProcessor(this.pluginListReaderThread));
            }
        }
    }

    protected void processAvailablePlugins() {
        this.installablePlugins = new ArrayList(this.availablePlugins.size());
        this.updatablePlugins = new ArrayList(this.availablePlugins.size());
        this.updateMap = new HashMap<PluginInfo, PluginInfo>();
        Map<String, PluginInfo> activePlugins = this.masterMap.getActivePlugins();
        for (PluginInfo info : this.availablePlugins.values()) {
            PluginInfo old = activePlugins.get(info.getName());
            if (old != null) {
                if (old.getDirectory() == PluginDir.BUILTIN) continue;
                this.updateMap.put(old, info);
                if (VersionComparator.compareVersion((String)info.getVersion(), (String)old.getVersion()) <= 0) continue;
                this.updatablePlugins.add(old);
                continue;
            }
            this.installablePlugins.add(info);
        }
    }

    public boolean update(Component parent) {
        return this.update(parent, this.updatablePlugins);
    }

    public boolean install(Component parent, Collection<PluginInfo> plugins) {
        List<LibInfo> downloads;
        List<LibInfo> list = downloads = this.pluginListIsReady ? this.masterMap.getDownloads(plugins, this.availablePlugins) : this.masterMap.getDownloads(plugins);
        if (!this.download(parent, downloads)) {
            return false;
        }
        Collection<PluginInfo> active = this.masterMap.getLoadablePlugins().values();
        boolean restart = this.getApplication().loadPlugins(active);
        for (PluginInfo plugin : active) {
            if (plugin.getErrorStatus() == null) continue;
            String message = "At least one plugin failed to load, see Plugin Manager for details";
            if (parent == null) {
                throw new IllegalArgumentException(message);
            }
            Application.error(parent, message);
        }
        this.cleanup();
        this.fireStateChanged();
        return restart;
    }

    public boolean uninstall(Component parent, Collection<PluginInfo> plugins) {
        ArrayList<PluginInfo> verified = new ArrayList<PluginInfo>(plugins.size());
        for (PluginDir dir : PluginDir.sgu()) {
            HashSet<PluginInfo> verDir = new HashSet<PluginInfo>();
            for (PluginInfo plugin : plugins) {
                PluginInfo installed;
                if (plugin.getDirectory() != dir || (installed = this.masterMap.getPlugin(plugin.getName(), dir)) == null) continue;
                verDir.add(installed);
                verDir.addAll(this.masterMap.getDependentPlugins(installed));
            }
            verified.addAll(verDir);
        }
        this.masterMap.remove(verified);
        boolean restart = false;
        for (PluginInfo plugin : verified) {
            try {
                PluginInfo loadedPlugin = this.getApplication().getPlugin(plugin.getName());
                if (loadedPlugin == null || loadedPlugin.getDirectory() != plugin.getDirectory()) continue;
                this.getApplication().stopPlugin(plugin);
                restart = true;
            }
            catch (IllegalArgumentException x) {
                restart = true;
            }
        }
        this.cleanup();
        this.fireStateChanged();
        return restart;
    }

    public boolean update(Component parent, Collection<PluginInfo> plugins) {
        ArrayList<PluginInfo> updates = new ArrayList<PluginInfo>(plugins.size());
        for (PluginInfo plugin : plugins) {
            PluginInfo availablePlugin = this.availablePlugins.get(plugin.getName());
            PluginInfo installedPlugin = this.masterMap.getPlugin(plugin.getName(), plugin.getDirectory());
            if (availablePlugin == null || installedPlugin == null || VersionComparator.compareVersion((String)availablePlugin.getVersion(), (String)installedPlugin.getVersion()) <= 0) continue;
            PluginInfo update = new PluginInfo(availablePlugin);
            update.setDirectory(installedPlugin.getDirectory());
            updates.add(update);
        }
        return this.install(parent, updates);
    }

    protected void cleanup() {
        this.installablePlugins = null;
        this.updatablePlugins = null;
        this.updateMap = null;
    }

    private boolean download(Component parent, List<LibInfo> libraries) {
        HashMap<File, String> downloads = new HashMap<File, String>(libraries.size() * 2);
        for (LibInfo lib : libraries) {
            downloads.put(lib.getFile(), lib.getHref());
        }
        PluginDownload download = new PluginDownload(downloads);
        Thread t = new Thread(download);
        t.start();
        JOptionPane.showMessageDialog(parent, download, "Downloading...", -1);
        Throwable status = download.getStatus();
        if (status != null) {
            download.cleanUp();
            String message = "Download failed: " + status;
            if (parent == null) {
                throw new IllegalArgumentException(message);
            }
            JOptionPane.showMessageDialog(parent, message, "Download error", 0);
            return false;
        }
        download.commit();
        this.masterMap.commit(libraries);
        return true;
    }

    public void restart(Component parentComponent) {
        int opt;
        if (parentComponent == null) {
            parentComponent = this.getApplication();
        }
        if ((opt = JOptionPane.showOptionDialog(parentComponent, "You must restart " + this.getApplication().getAppName() + " for these changes to take effect", "Restart application", -1, -1, null, new String[]{"Restart Now", "Restart Later"}, "Restart Now")) == 0) {
            this.getApplication().restart();
        }
    }

    void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    private class PluginListProcessor
    implements Runnable {
        private Thread thr;

        PluginListProcessor(Thread readerThread) {
            this.thr = readerThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PluginManager.this.pluginListLock;
            synchronized (object) {
                if (this.thr != PluginManager.this.pluginListReaderThread) {
                    return;
                }
                PluginManager.this.processAvailablePlugins();
                PluginManager.this.pluginListReaderThread = null;
                PluginManager.this.pluginListIsReady = true;
            }
            if (!PluginManager.this.updatablePlugins.isEmpty() && !PluginManager.this.dialogVisible && PluginManager.this.preferences.isNotifyPluginUpdates()) {
                PluginManager.this.offerUpdate();
            }
            if (PluginManager.this.preferences.isDownloadMissing()) {
                Studio app = PluginManager.this.getApplication();
                List<LibInfo> missing = PluginManager.this.masterMap.getDownloads(PluginManager.this.getActivePlugins().values(), PluginManager.this.availablePlugins);
                if (!missing.isEmpty() && PluginManager.this.download(app, missing)) {
                    boolean restart = app.loadPlugins(PluginManager.this.masterMap.getLoadablePlugins().values());
                    if (restart) {
                        PluginManager.this.restart(app);
                    } else {
                        app.reportPluginException();
                    }
                }
            }
            PluginManager.this.cleanup();
            PluginManager.this.fireStateChanged();
        }
    }
}

