/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.InputConversionEngine;
import org.lsst.ccs.command.TokenizedCommand;

public class RawCommand
implements BasicCommand {
    private final String commandName;
    private final List<Object> arguments;

    public RawCommand(String commandName, List<Object> arguments) {
        this.commandName = commandName;
        this.arguments = arguments;
    }

    @Override
    public String getCommand() {
        return this.commandName;
    }

    Object getArgument(int index) {
        return this.arguments.get(index);
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    @Override
    public int getArgumentCount() {
        return this.arguments.size();
    }

    public static RawCommand toRawCommand(BasicCommand command, Method method, InputConversionEngine engine) throws CommandInvocationException {
        if (command instanceof RawCommand) {
            return (RawCommand)command;
        }
        if (command instanceof TokenizedCommand) {
            return RawCommand.convertToRaw((TokenizedCommand)command, method, engine);
        }
        throw new CommandInvocationException("Error: Unknown type of command " + command.getClass().getName(), new Object[0]);
    }

    private static RawCommand convertToRaw(TokenizedCommand tokenizedCommand, Method method, InputConversionEngine engine) throws CommandInvocationException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        ArrayList<Object> args = new ArrayList<Object>(parameterTypes.length);
        boolean varArgs = method.isVarArgs();
        int i = 0;
        while (i < parameterTypes.length) {
            if (varArgs && i == parameterTypes.length - 1) {
                Class<?> varClass = parameterTypes[i];
                Class<?> elemClass = varClass.getComponentType();
                Object theArray = Array.newInstance(elemClass, tokenizedCommand.getArgumentCount() - parameterTypes.length + 1);
                int j = 0;
                while (j < Array.getLength(theArray)) {
                    Array.set(theArray, j, engine.convertArgToType(tokenizedCommand.getArgument(i + j), elemClass));
                    ++j;
                }
                args.add(theArray);
            } else {
                args.add(engine.convertArgToType(tokenizedCommand.getArgument(i), parameterTypes[i]));
            }
            ++i;
        }
        return new RawCommand(tokenizedCommand.getCommand(), args);
    }
}

