/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.LocalCommandDictionary;
import org.lsst.ccs.command.MethodBasedCommandDictionary;
import org.lsst.ccs.command.MethodBasedDictionaryCommand;
import org.lsst.ccs.command.annotations.Command;

public class CommandDictionaryBuilder
implements LocalCommandDictionary {
    private MethodBasedCommandDictionary dict;
    private final Map<DictionaryCommand, Method> methods = new HashMap<DictionaryCommand, Method>();
    private static Method[] arrayModel = new Method[0];

    CommandDictionaryBuilder(Class klass) {
        this.init(klass);
    }

    @Override
    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    @Override
    public Method getMethod(BasicCommand command) {
        DictionaryCommand dc = this.dict.findCommand(command);
        if (dc == null) {
            return null;
        }
        return this.methods.get(dc);
    }

    @Override
    public Method getMethod(DictionaryCommand dc) {
        if (dc == null) {
            return null;
        }
        return this.methods.get(dc);
    }

    @Override
    public Collection<Method> getMethods() {
        return this.methods.values();
    }

    private void init(Class targetClass) {
        this.dict = new MethodBasedCommandDictionary();
        Method[] methodArray = targetClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command annotation;
            Method targetMethod = methodArray[n2];
            Method annotatedMethod = CommandDictionaryBuilder.getAnnotationWithInheritance(targetMethod, Command.class);
            if (annotatedMethod != null && (annotation = annotatedMethod.getAnnotation(Command.class)) != null) {
                MethodBasedDictionaryCommand dc = new MethodBasedDictionaryCommand(annotatedMethod, annotation);
                this.dict.add(dc);
                this.methods.put(dc, targetMethod);
            }
            ++n2;
        }
    }

    private static <T extends Annotation> Method getAnnotationWithInheritance(Method method, Class<T> annotationClass) {
        while (true) {
            T annotation;
            if ((annotation = method.getAnnotation(annotationClass)) != null) {
                return method;
            }
            Class<?> superClass = method.getDeclaringClass().getSuperclass();
            if (superClass == null) break;
            try {
                method = superClass.getMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            break;
        }
        return null;
    }
}

