/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.awt.GraphicsEnvironment;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.utilities.beanutils.Optional;
import org.lsst.ccs.utilities.logging.ConsoleHandlerN;
import org.lsst.ccs.utilities.logging.ContextLogManager;
import org.lsst.ccs.utilities.tracers.Tracer;

public class LogManagement {
    public static final ErrorManager ERROR_MANAGER = new ErrorManager();
    private static boolean configInitialized = true;

    static {
        Optional<LogManager> optManager = ContextLogManager.getSystemLoaderLogManager();
        if (!optManager.isPresent()) {
            String configName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("java.util.logging.config.file", "logging.properties");
            InputStream is = null;
            if (configName == null) {
                is = BootstrapResourceUtils.getBootstrapPropertiesInputStream("/logging.properties", LogManagement.class);
                configName = "global logging.properties resource";
            } else {
                try {
                    is = new FileInputStream(configName);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            if (is != null) {
                LogManagement.reloadConfigurationFrom(configName, is);
            } else {
                LogManagement.setConfigInitialized(false);
                Level defaultLevel = LogManagement.cleanConsole();
                LogManagement.setDefaultConsoleHandler(defaultLevel);
                ERROR_MANAGER.error("WARNING: no access to  " + configName + "(but cleaning Console access)", null, 4);
            }
        }
    }

    public static boolean isConfigInitialized() {
        return configInitialized;
    }

    public static void setConfigInitialized(boolean configInitialized) {
        LogManagement.configInitialized = configInitialized;
    }

    public static Level cleanConsole() {
        Logger globalHandler = Logger.getLogger("");
        Handler[] handlers = globalHandler.getHandlers();
        Level consoleLevel = null;
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler.getClass().equals(ConsoleHandler.class)) {
                consoleLevel = handler.getLevel();
                globalHandler.removeHandler(handler);
            }
            ++n2;
        }
        return consoleLevel;
    }

    public static void setDefaultConsoleHandler(Level consoleLevel) {
        Logger globalHandler = Logger.getLogger("");
        if (consoleLevel != null && !GraphicsEnvironment.isHeadless()) {
            ConsoleHandlerN consoleHandlerN = new ConsoleHandlerN();
            consoleHandlerN.setLevel(consoleLevel);
            globalHandler.addHandler(consoleHandlerN);
        }
    }

    static void reloadConfigurationFrom(String name, InputStream is) {
        LogManager manager = LogManager.getLogManager();
        try {
            manager.readConfiguration(is);
            assert (Tracer.trace("handlers=" + manager.getProperty("handlers")));
        }
        catch (IOException e) {
            ERROR_MANAGER.error("can't open " + name, e, 4);
        }
    }
}

