/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingFrame;

public class TestSymbolPerformance
extends JPanel {
    public TestSymbolPerformance() {
        this.setOpaque(false);
    }

    public void paintComponent(Graphics g) {
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        vg.setColor(Color.RED);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        vg.setColor(Color.BLACK);
        this.writeSymbols(10000, vg, 0.0, dim.height / 2, dim.width, 4, 4);
        this.writeSymbols(10000, vg, dim.height / 2, dim.height / 2, dim.width, 5, 256);
    }

    private void writeSymbols(int n, VectorGraphics vg, double yo, double height, double width, int type, int levelsPerColor) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            double x = Math.random() * width;
            double y = yo + 20.0 + Math.random() * (height - 20.0);
            int colorUnit = 256 / levelsPerColor;
            int r = (int)(Math.random() * 256.0 / (double)colorUnit) * colorUnit;
            int g = (int)(Math.random() * 256.0 / (double)colorUnit) * colorUnit;
            int b = (int)(Math.random() * 256.0 / (double)colorUnit) * colorUnit;
            vg.setColor(new Color(r, g, b));
            vg.fillSymbol(x, y, 6.0, type);
        }
        long end = System.currentTimeMillis();
        vg.setColor(Color.BLACK);
        vg.drawString(n + " symbols of type " + type + " filled in " + (end - start) + " ms", 10.0, yo + 15.0);
    }

    public static void main(String[] args) {
        TestingFrame frame = new TestingFrame("Test Symbol Performance");
        frame.addPanel(new TestSymbolPerformance());
        frame.pack();
        frame.setSize(new Dimension(600, 600));
        frame.setVisible(true);
    }
}

