/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.net.util.SubnetUtils;
import org.freehep.util.ClasspathUtilities;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleNetworkUtilities;
import org.lsst.ccs.utilities.tracers.Names;
import org.python.core.PyCode;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JythonInterpreterConsole
extends Subsystem {
    static Options commandLineOptions;
    static String PORT_OPTION;
    static String HELP_OPTION;
    private ServerSocket serverSocket;
    private int portNumber;
    private List<SubnetUtils> allowedIps = null;

    static {
        PORT_OPTION = "port";
        HELP_OPTION = "help";
        commandLineOptions = new Options();
        commandLineOptions.addOption("p", PORT_OPTION, true, "Port to run the interpreter on.");
        commandLineOptions.addOption("h", HELP_OPTION, false, "Print the help message");
    }

    public JythonInterpreterConsole(int portNumber) throws IOException {
        this.setName(Names.almostUniqueAgentName((String)"JythonInterpreterConsole"));
        this.setStatusBroadcastPeriod(0);
        this.start();
        Properties props = System.getProperties();
        PythonInterpreter.initialize(props, props, null);
        this.serverSocket = new ServerSocket(portNumber);
        this.portNumber = portNumber;
        this.allowedIps = JythonConsoleNetworkUtilities.loadNetwrokAccessInformation();
    }

    private void startListeningOnSocket() throws IOException {
        System.out.println("Jython Console is accepting socket connections on port " + this.portNumber);
        Socket clientSocket = null;
        while ((clientSocket = this.serverSocket.accept()) != null) {
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
            InetAddress clientAddress = clientSocket.getInetAddress();
            if (JythonConsoleNetworkUtilities.isInetAddressLocalhost(clientAddress) || JythonConsoleNetworkUtilities.isIpAddressAllowed(clientAddress.getHostAddress(), this.allowedIps)) {
                out.println("ConnectionOK");
                InternalJythonInterpreter interpreter = new InternalJythonInterpreter(clientSocket);
                Thread interpreterThread = new Thread(interpreter);
                interpreterThread.start();
                continue;
            }
            System.out.println("*** WARNING: socket connection from " + clientAddress.getHostAddress() + " closed as it's neither localhost nor in the list of accepted IP addresses.");
            out.println("ConnectionRefused");
            out.close();
            clientSocket.close();
        }
    }

    public static void main(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(commandLineOptions, args, true);
        if (line.hasOption(HELP_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "CCS Jython Interpreter Console", "", commandLineOptions, "", true);
        } else {
            Properties sysProps = System.getProperties();
            sysProps.setProperty("python.packages.paths", "full.java.class.path,sun.boot.class.path,app.class.path");
            ClasspathUtilities.setFullSystemClasspathInSystemProperty("full.java.class.path");
            int portNumber = 4444;
            if (line.hasOption(PORT_OPTION)) {
                portNumber = Integer.parseInt(line.getOptionValue(PORT_OPTION));
            }
            try {
                JythonInterpreterConsole interpreterConsole = new JythonInterpreterConsole(portNumber);
                interpreterConsole.startListeningOnSocket();
            }
            catch (IOException ioe) {
                System.out.println("Failed to start the Jython Interpreter Console.");
                throw new RuntimeException(ioe);
            }
        }
    }

    class InternalJythonInterpreter
    implements Runnable {
        Socket clientSocket = null;
        BufferedReader in;
        PrintWriter out;

        public InternalJythonInterpreter(Socket socket) throws IOException {
            this.clientSocket = socket;
            this.out = new PrintWriter(socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String contentId = null;
            StringBuffer executionBuffer = new StringBuffer();
            PySystemState state = new PySystemState();
            PythonInterpreter pyInterpreter = new PythonInterpreter(null, state);
            pyInterpreter.setOut(this.out);
            pyInterpreter.setErr(this.out);
            try {
                while (true) {
                    String inputLine;
                    if ((inputLine = this.in.readLine()) == null) {
                        return;
                    }
                    if (inputLine.startsWith("startContent:")) {
                        contentId = inputLine.replace("startContent:", "");
                        executionBuffer.setLength(0);
                        continue;
                    }
                    if (inputLine.startsWith("endContent:")) {
                        System.out.println("Compiling content " + contentId);
                        try {
                            try {
                                PyCode code = pyInterpreter.compile(executionBuffer.toString());
                                pyInterpreter.exec(code);
                            }
                            catch (Exception executionException) {
                                executionException.printStackTrace(this.out);
                                this.out.println("doneExecution:" + contentId);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            this.out.println("doneExecution:" + contentId);
                            throw throwable;
                        }
                        this.out.println("doneExecution:" + contentId);
                        continue;
                    }
                    executionBuffer.append(String.valueOf(inputLine) + "\n");
                }
            }
            catch (IOException iOException) {
                System.out.println("********** Has the client closed the connection? " + this.clientSocket.isConnected());
            }
        }
    }
}

