/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.subsystems.console.BaseConsole;
import org.lsst.ccs.subsystems.console.TargetArgumentCompleter;

public class JLineConsole
extends BaseConsole {
    private ConsoleReader reader = null;
    private boolean noRedraw = Boolean.getBoolean("noRedraw");
    private TargetArgumentCompleter targetCompleter = new TargetArgumentCompleter(new String[]{"invoke", "unlock"});
    private TargetArgumentCompleter lockTargetCompleter = new TargetArgumentCompleter(new String[]{"lock", "loadCommandsForSubsystem"});
    static Logger loggerCom = Logger.getLogger("org.lsst.ccs_com");
    static Level baseComLevel = loggerCom.getLevel();

    JLineConsole(String name) {
        super(name);
    }

    public static void main(String[] args) {
        JLineConsole cons = new JLineConsole(args.length > 0 ? args[0] : null);
        cons.start();
        loggerCom.setLevel(Level.SEVERE);
        cons.runConsole();
        try {
            cons.shutdown();
        }
        catch (HardwareException he) {
            he.printStackTrace();
            throw new RuntimeException(he);
        }
        System.out.print("End Console\n");
        System.exit(0);
    }

    @Override
    protected void messageFromBus(String message) {
        super.messageFromBus(message);
        if (!this.noRedraw && this.reader != null) {
            try {
                this.reader.redrawLine();
            }
            catch (IOException iOException) {}
        }
    }

    public void runConsole() {
        boolean isok = true;
        try {
            this.reader = new ConsoleReader();
        }
        catch (IOException e) {
            System.out.println(e);
            return;
        }
        this.reader.setBellEnabled(false);
        try {
            FileHistory history = new FileHistory(new File(String.valueOf(System.getProperty("user.home")) + "/.lsst_jline.txt"));
            this.reader.setHistory((History)history);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        LinkedList<StringsCompleter> completors = new LinkedList<StringsCompleter>();
        completors.add(new StringsCompleter(new String[]{"lock", "unlock", "config", "configSet", "configTag", "configDrop", "invoke", "syncInvoke", "abort", "signal", "quit"}));
        this.reader.addCompleter((Completer)new ArgumentCompleter(completors));
        System.out.println("Console ready, locking key = " + this.getMessagingFactory().getToken());
        loggerCom.setLevel(baseComLevel);
        while (isok) {
            try {
                String line = this.reader.readLine("console> ");
                if (line == null) {
                    isok = false;
                    continue;
                }
                if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) {
                    isok = false;
                    continue;
                }
                if (line.trim().equals("")) continue;
                try {
                    this.execute(line);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (IOException iOException) {
                isok = false;
            }
        }
    }
}

