/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap.resources;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.BootstrapUtils;

public class ResourcesTreeProperties
extends Properties {
    private final String resourceDirectory;
    private final String propertyFileName;
    private final Properties parent;
    private static final String prop_str_pattern = ".*(\\$\\[prop\\.(.*)\\]).*";
    private static final Pattern prop_pattern = Pattern.compile(".*(\\$\\[prop\\.(.*)\\]).*");

    public ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public String getPropertyFileName() {
        return this.propertyFileName;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Properties getParent() {
        return this.parent;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        String valueStr = BootstrapUtils.parseProperty((String)value);
        return super.put(key, valueStr);
    }

    public void copyProperties(Properties props) {
        if (this.parent != null) {
            if (this.parent instanceof ResourcesTreeProperties) {
                ((ResourcesTreeProperties)this.parent).copyProperties(props);
            } else {
                for (Object object : this.parent.keySet()) {
                    props.put(object, this.parent.get(object));
                }
            }
        }
        for (Map.Entry entry : this.entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
    }
}

